function [Xiter, RelErr, RelRes, Alpha, tot_it, cycle_it, stopC_it] = fcgls_rp_nn_ReSt (A, b, m_in, m_out, xex, x0, full, stopC)
%
% initialization & allocation of memory
N = length(xex);
m_tot = m_in*m_out;
Xiter = zeros(N,m_tot);
RelErr = zeros(m_tot,1);
RelRes = zeros(m_tot,1);
Alpha = zeros(m_tot,1);
tot_it = 0;
cycle_it = zeros(m_out,1);
if nargin == 5
    % setting the initial guess
    x0 = zeros(N,1);
    % setting the truncation parameter
    full = 0;
    % setting the stopping criterion
    stopC = 'none';
elseif nargin == 6
    % setting the truncation parameter
    full = 0;
    % setting the stopping criterion
    stopC = 'none';
elseif nargin == 7
    % setting the stopping criterion
    stopC = 'none';
end
if ~ischar(stopC)
    stopC_it = zeros(m_out,1);
else
    stopC_it = [];
end
%
for i = 1:m_out
    % outer iterations
    display(i)
    % inner iterations
    [Xiter_in, RelErr_in, RelRes_in, istop_in, stopC_it_in, Alpha_in] = fcgls_rp_nn(A, b, x0, m_in, xex, full,stopC);
    if ~ischar(stopC) && ~isempty(stopC_it_in)
        stopC_it(i) = stopC_it_in;
    end
    if istop_in >= 1
        new_tot_it = tot_it+istop_in;
        Xiter(:,tot_it+1:new_tot_it) = Xiter_in;
        RelErr(tot_it+1:new_tot_it) = RelErr_in;
        RelRes(tot_it+1:new_tot_it) = RelRes_in;
        Alpha(tot_it+1:new_tot_it) = Alpha_in;
        tot_it = new_tot_it;
        x0 = Xiter_in(:,end); x0(x0<0)=0;
        cycle_it(i) = istop_in;
    else
        break
    end
end
Xiter = Xiter(:,1:tot_it);
RelErr = RelErr(1:tot_it);
RelRes = RelRes(1:tot_it);
Alpha = Alpha(1:tot_it);
