function berr = addRELnoise(b,sigma)
%
% Function employed to add gaussian white noise to and unperturbed
% right-hand-side b
% Inputs:
%           - b:     unperturbed right-hand-side
%           - sigma: desired noise level norm(e)/norm(b)
% Output:
%           - berr:  corrupted right-hand side
% Remark: the input b can be both a 1D and a 2D array. In the former case
% the norm considered is the 2-norm; in the latter case the norm considered
% is the Frobenius norm
%
if size(b,2)==1 % 1D array
    n = length(b);    
    r = randn(n,1);
    berr = b + ((sigma*norm(b))/norm(r))*r;
else % 2D array
    [n,m] = size(b);
    r = randn(n,m);
    berr = b + ((sigma*norm(b,'fro'))/norm(r,'fro'))*r;
end
    