function [params] = parse_model_inputs(varargin)
params = struct;
for i=1:2:numel(varargin)
    params.(lower(varargin{i})) = varargin{i+1};
end
if (~isfield(params, 'sigma'))
    params.sigma = input('Variance sigma = ? (default 1): ');
    if (isempty(params.sigma))
        params.sigma = 1;
    end
end
if (~isfield(params, 'corr_length'))
    params.corr_length = input('corr_length = ? (default 1): ');
    if (isempty(params.corr_length))
        params.corr_length = 1;
    end
end
if (~isfield(params, 'nu'))
    params.nu = input('Decay rate nu = ? (default 3): ');
    if (isempty(params.nu))
        params.nu = 3;
    end
end
if (~isfield(params, 'ydist'))
    params.ydist = input('Y distribution = ? (''normal'',''uniform'') (default ''normal''): ', 's');
    if (isempty(params.ydist))
        params.ydist = 'normal';
    end
end
if (strcmpi(params.ydist, 'normal'))
    check_hermite;
else
    check_lgwt;
end
if (~isfield(params, 'coeff'))
    params.coeff = input('Coefficient model = ? (''exp'',''affine'') (default ''exp''): ', 's');
    if (isempty(params.coeff))
        params.coeff = 'exp';
    end
end
if (~isfield(params, 'n_moments'))
    params.n_moments = input('Number of moments (QoIs) = ? (default 10): ');
    if (isempty(params.n_moments))
        params.n_moments = 10;
    end
end
if (~isfield(params, 'runs'))
    params.runs = input('Number of runs = ? (default 4): ');
    if (isempty(params.runs))
        params.runs = 4;
    end
end
if (~isfield(params, 'lvls'))
    params.lvls = input('Levels to test = ? (enter a vector) (default 1:4): ');
    if (isempty(params.lvls))
        params.lvls = 1:4;
    end
end

if (~strcmpi(params.coeff, 'exp'))&&(strcmpi(params.ydist, 'normal'))
    error('Affine coefficient cannot have normal y (coefficient is not positive)');
end
end


function check_hermite()
if (exist('gauss_hermite_rule', 'file')==0)
    try
        fprintf('Gauss-Hermite rule is not found. Downloading...\n');
        urlwrite('https://raw.githubusercontent.com/ezander/sglib-testing/master/sglib/pce/hermite.m', 'hermite.m');
        urlwrite('https://raw.githubusercontent.com/ezander/sglib-testing/master/sglib/quadrature/gauss_hermite_rule.m', 'gauss_hermite_rule.m');
        rehash;
    catch ME
        error('%s. Please download hermite.m and gauss_hermite_rule.m from https://github.com/ezander/sglib-testing/', ME.message);
    end
end
end

function check_lgwt()
if (exist('lgwt', 'file')==0)
    try
        fprintf('Gauss-Legendre rule is not found. Downloading...\n');
        urlwrite('https://uk.mathworks.com/matlabcentral/mlc-downloads/downloads/submissions/4540/versions/1/download/zip', 'lgwt.zip');
        unzip('lgwt.zip');
        rehash;
    catch ME
        error('%s. Please download lgwt.m (from e.g. MatlabCentral)', ME.message);
    end
end

end
