boolean RunDebug = false;
PFont font; 

class Node
{
  int Number;
  float XCoord, YCoord;
  boolean XFixed, YFixed;
  float XLoad, YLoad;
  float XDisplacement, YDisplacement;
  
  Node (int n, float x, float y, boolean xfix, boolean yfix, float xld, float yld)
  {
    Number = n;
    XCoord = x;
    YCoord = y;
    XFixed = xfix;
    YFixed = yfix;
    XLoad = xld;
    YLoad = yld;
    XDisplacement = 0.0;
    YDisplacement = 0.0;
  }
}

class Line
{
  int Number;
  int NodeStart, NodeEnd;
  float Area, Force, XLength, YLength;
  
  Line (int n, int start, int end, float a)
  {
    Number = n;
    NodeStart = start;
    NodeEnd = end;
    Area = a*a;
    Force = 0.0;
    XLength = arrayNodes.get(NodeEnd).XCoord-arrayNodes.get(NodeStart).XCoord;
    YLength = arrayNodes.get(NodeEnd).YCoord-arrayNodes.get(NodeStart).YCoord;
  }
}

float Mouse_X, Mouse_Y, Mouse_OldX, Mouse_OldY;
float RotateX, RotateY, PanX, PanY, Zoom = 100.0;
float RotateX_Drag, RotateY_Drag, PanX_Drag, PanY_Drag, Zoom_Drag;
int NUM_NODES = 0, NUM_LINES = 0;
float YoungsModulus = 205000.0;
int Animation_Frame, Animation_Increment = -1, Animation_Limit = 10;

ArrayList<Node> arrayNodes;
ArrayList<Line> arrayLines;
float[][] stiffness_matrix;
float[][] stiffness_matrix_inverse;
float MaxDisplacement, TotalWeight;


void setup() 
{ 
  size(800, 320);
  font = loadFont("ArialMT-48.vlw");
  colorMode(RGB, 1);
  stroke(0.9, 0.9, 0.9);
  frameRate(Animation_Limit);
  PanX = width/2;
  PanY = height/2;
  Zoom = 3.0;
  
  //Calculate("18.0", "16", "50.0", "1.0");
  MakeArsenal(200.0, 18.0, 9.0, 16, 1.0, 1.0);
  
  //SaveParametric();
} 

void SaveParametric()
{
  String buffer, lines_out = "";
  PrintWriter aFile = createWriter("Output.csv");
  println(aFile);
  
  lines_out += "XXXX";
  for (int ts=3; ts<40; ts++)
  {
    lines_out += "," + str(ts);
  }
  lines_out += "\n";
  for (float th=2.0; th<40.0; th+=1.0)
  {
    lines_out += str(th);
    for (int ts=3; ts<40; ts++)
    {
      Calculate(str(th), str(ts), "0.5", "10.0");
      noLoop();
      lines_out += "," + str(Cost());
    }
    lines_out += "\n";
  }
  aFile.print(lines_out);
  aFile.flush();
  aFile.close();
  exit();
}
void SaveParametricList()
{
  PrintWriter aFile = createWriter("Output.csv");
  for (float th=2.0; th<40.0; th+=1.0)
  {
    for (int ts=3; ts<40; ts++)
    {
      Calculate(str(th), str(ts), "0.25", "1.0");
      noLoop();
      aFile.println( str(th) + "," + str(ts) + "," + str(Cost()) );
    }
  }
  aFile.flush();
  aFile.close();
  exit();
}



void Calculate(String th, String ts, String eh, String cw)
{
    noLoop();
    float truss_height = float(th);
    float end_height = float(eh);
    int top_segments = int(ts);
    float chord_weight = float(cw);
    if (end_height>=100.0) end_height = 99.0;
    if (end_height<=1.0) end_height = 1.0;
    if (truss_height<=0.0) truss_height = 1.0;
    if (top_segments<3) top_segments = 3;
    if (chord_weight<=0.0) chord_weight = 1.0;
    MakeArsenal(200.0, truss_height, 0.01*truss_height*end_height, top_segments, chord_weight, 1.0);
    Solve();
    loop();
}

float Cost()
{
  //float cost = 0.02*MaxDisplacement+pow(TotalWeight, 1.0/3.0);
  //float cost = pow(MaxDisplacement, 0.25)+0.5*pow(TotalWeight, 0.5);
  float cost = pow(pow(MaxDisplacement, 0.25)+0.003*TotalWeight, 2.0);
  return cost*cost;
}

void Solve()
{
  if (RunDebug) OutputNodes();
  if (NUM_LINES>0)
  {
    BuildStiffnessMatrix();
    if (RunDebug)
    {
        println("\n\nRAW MATRIX :");
        OutputMatrix();
    }
    ApplyBoundaryConditions();
    if (RunDebug)
    {
        println("\n\nRAW MATRIX : PLUS BCs");
        OutputMatrix();
    }
    InvertStiffnessMatrix();
    if (RunDebug)
    {
        println("\n\nINVERSE MATRIX :");
        OutputMatrix();
    }
    SolveDisplacements();
    SolveForces();
    if (RunDebug) OutputNodes();
    if (RunDebug) OutputLines();
  }
}

void MakeArsenal(float truss_width, float truss_height, float end_height, int top_segments, float area_chord, float area_lace)
{
  float centre_y, radius, half_angle, x, y, load;
  boolean xfix, yfix;
  int num;
  
  arrayNodes = new ArrayList<Node>();
  arrayLines = new ArrayList<Line>();
  
  centre_y = 0.5*(0.25*truss_width*truss_width+end_height*end_height-truss_height*truss_height)/(end_height-truss_height);
  radius = sqrt(0.25*truss_width*truss_width+(end_height-centre_y)*(end_height-centre_y));
  half_angle = asin(0.5*truss_width/radius);
  if (RunDebug) println(centre_y, radius, half_angle);

  //  Make Top Chord
  num = 0;
  for (int count=0; count<=top_segments; count++)
  {
      num++;
      x = radius*sin(-half_angle+2*half_angle*count/top_segments);
      y = centre_y + radius*cos(-half_angle+2*half_angle*count/top_segments);
      xfix = yfix = ((count==0)||(count==top_segments));
    
      arrayNodes.add(new Node(num, x, -y, xfix, yfix, 0.0, 0.0));
      if (count>0) arrayLines.add(new Line(num-1, count-1, count, area_chord));
  }
  
  //  Make Bottom Chord
  centre_y = 0.5*(0.25*truss_width*truss_width+end_height*end_height)/end_height;
  radius = sqrt(0.25*truss_width*truss_width+(end_height-centre_y)*(end_height-centre_y));
  half_angle = asin(0.5*truss_width/radius);
  if (RunDebug) println(centre_y, radius, half_angle);
  for (int count=1; count<top_segments-1; count++)
  {
      num++;
      x = radius*sin(-half_angle+2*half_angle*(count+0.5)/top_segments);
      y = centre_y - radius*cos(-half_angle+2*half_angle*(count+0.5)/top_segments);
    
      arrayNodes.add(new Node(num, x, -y, false, false, 0.0, 0.0));
      if (count==1) 
      {
          arrayLines.add(new Line(num-1, 0, top_segments+count, area_chord));
      }
      else  
      {
          arrayLines.add(new Line(num-1, top_segments+count-1, top_segments+count, area_chord));
      }
  }
  arrayLines.add(new Line(num-1, 2*top_segments-2, top_segments, area_chord));
  
  //  Make Laces
  for (int count=1; count<top_segments-1; count++)
  {
      arrayLines.add(new Line(num++, count, top_segments+count, area_lace));
      arrayLines.add(new Line(num++, top_segments+count, count+1, area_lace));
  }
  
  NUM_NODES = arrayNodes.size();
  NUM_LINES = arrayLines.size();

  //  Add Selfweight
  Line aLine;
  float len;
  TotalWeight = 0.0;
  for (int count=0; count<NUM_LINES; count++)
  {
    aLine = arrayLines.get(count);
    len = sqrt(aLine.XLength*aLine.XLength + aLine.YLength*aLine.YLength);
    load = pow(aLine.Area, 0.25) * len;
    TotalWeight += load;
    
    if (count<top_segments) load += 1000.0*len; 
    
    arrayNodes.get(aLine.NodeStart).YLoad += 0.5*load;
    arrayNodes.get(aLine.NodeEnd).YLoad += 0.5*load;
  }
  
}
 
 
void BuildStiffnessMatrix()
{
  int start_dof, end_dof;
  float member_length, x_length, y_length, xx_stiffness, yy_stiffness, xy_stiffness, EA_over_Lcubed;
  Line aLine;
  
  stiffness_matrix = new float[2*NUM_NODES][2*NUM_NODES];
  stiffness_matrix_inverse = new float[2*NUM_NODES][2*NUM_NODES];

  //  Set inverse to Identity Martix;
  for (int row=0; row<2*NUM_NODES; row++)
  {
    for (int col=0; col<2*NUM_NODES; col++) stiffness_matrix_inverse[row][col] = 0.0;
    stiffness_matrix_inverse[row][row] = 1.0;
  }
  
  for (int count=0; count<NUM_LINES; count++)
  {
    aLine = arrayLines.get(count);
    member_length = sqrt( aLine.XLength*aLine.XLength + aLine.YLength*aLine.YLength );
    
    EA_over_Lcubed = YoungsModulus*aLine.Area/(member_length*member_length*member_length);
    xx_stiffness = EA_over_Lcubed*aLine.XLength*aLine.XLength;
    yy_stiffness = EA_over_Lcubed*aLine.YLength*aLine.YLength;
    xy_stiffness = EA_over_Lcubed*aLine.XLength*aLine.YLength;
    
    start_dof = 2*(aLine.NodeStart);
    end_dof = 2*(aLine.NodeEnd);
    
    stiffness_matrix[start_dof][start_dof] += xx_stiffness;
    stiffness_matrix[end_dof][end_dof] += xx_stiffness;
    stiffness_matrix[start_dof][end_dof] -= xx_stiffness;
    stiffness_matrix[end_dof][start_dof] -= xx_stiffness;
    
    stiffness_matrix[start_dof+1][start_dof+1] += yy_stiffness;
    stiffness_matrix[end_dof+1][end_dof+1] += yy_stiffness;
    stiffness_matrix[start_dof+1][end_dof+1] -= yy_stiffness;
    stiffness_matrix[end_dof+1][start_dof+1] -= yy_stiffness;
    
    stiffness_matrix[start_dof+1][start_dof] += xy_stiffness;
    stiffness_matrix[end_dof+1][end_dof] += xy_stiffness;
    stiffness_matrix[start_dof+1][end_dof] -= xy_stiffness;
    stiffness_matrix[end_dof+1][start_dof] -= xy_stiffness;
    
    stiffness_matrix[start_dof][start_dof+1] += xy_stiffness;
    stiffness_matrix[end_dof][end_dof+1] += xy_stiffness;
    stiffness_matrix[start_dof][end_dof+1] -= xy_stiffness;
    stiffness_matrix[end_dof][start_dof+1] -= xy_stiffness;
  }
}

void ApplyBoundaryConditions()
{
  int x_dof, y_dof;
  Node aNode;
  
  for (int count=0; count<NUM_NODES; count++)
  {
    aNode = arrayNodes.get(count);
    x_dof = 2*(aNode.Number-1);
    y_dof = x_dof+1;
    
    if (aNode.XFixed)
    {
      for (int dof_count=0; dof_count<NUM_NODES*2; dof_count++)
      {
        stiffness_matrix[x_dof][dof_count] = 0.0;
        stiffness_matrix[dof_count][x_dof] = 0.0;
      }
      stiffness_matrix[x_dof][x_dof] = 1.0;
      
      aNode.XLoad = 0.0;
    }
    
    if (aNode.YFixed)
    {
      for (int dof_count=0; dof_count<NUM_NODES*2; dof_count++)
      {
        stiffness_matrix[y_dof][dof_count] = 0.0;
        stiffness_matrix[dof_count][y_dof] = 0.0;
      }
      stiffness_matrix[y_dof][y_dof] = 1.0;
      
      aNode.YLoad = 0.0;
    }
  }
}


void InvertStiffnessMatrix()
{
  int current_row, row, col, count, biggest;
  float pivot_val;
    
  for (current_row=0; current_row<2*NUM_NODES; current_row++)
  {
    //  Find Biggest Pivot
    biggest = current_row;
    for (row=current_row+1; row<2*NUM_NODES; row++) if (stiffness_matrix[row][current_row]>stiffness_matrix[biggest][current_row]) biggest = row;
    
    if (biggest!=current_row)
    {
      //  Swap current_row for one with biggest pivot
      for (col=0; col<2*NUM_NODES; col++)
      {
        pivot_val = stiffness_matrix[current_row][col];
        stiffness_matrix[current_row][col] = stiffness_matrix[biggest][col];
        stiffness_matrix[biggest][col] = pivot_val;
        
        pivot_val = stiffness_matrix_inverse[current_row][col];
        stiffness_matrix_inverse[current_row][col] = stiffness_matrix_inverse[biggest][col];
        stiffness_matrix_inverse[biggest][col] = pivot_val;
      }
    }
    
    //  Divide row through by pivot
    pivot_val = stiffness_matrix[current_row][current_row];
    for (col=0; col<2*NUM_NODES; col++)
    {
      stiffness_matrix[current_row][col] /= pivot_val;
      stiffness_matrix_inverse[current_row][col] /= pivot_val;
    }
    
    //  Subtract multiple of current row from all others below
    for (row=current_row+1; row<2*NUM_NODES; row++)
    {
      pivot_val = stiffness_matrix[row][current_row];
      for (col=0; col<2*NUM_NODES; col++)
      {
        stiffness_matrix[row][col] -= pivot_val*stiffness_matrix[current_row][col];
        stiffness_matrix_inverse[row][col] -= pivot_val*stiffness_matrix_inverse[current_row][col];
      }
    }
    
  }
    
  //  Matrix is now Upper Triangular
  for (current_row=2*NUM_NODES-2; current_row>=0; current_row--)
  {
    for (row=current_row+1; row<2*NUM_NODES; row++)
    {
      pivot_val = stiffness_matrix[current_row][row];
      for (col=0; col<2*NUM_NODES; col++)
      {
        stiffness_matrix[current_row][col] -= pivot_val*stiffness_matrix[row][col];
        stiffness_matrix_inverse[current_row][col] -= pivot_val*stiffness_matrix_inverse[row][col];
      }      
    }
  }
  
}

void SolveDisplacements()
{
  int x_dof, y_dof, x_count, y_count;
  Node aNode;
  float[] load_vector = new float[2*NUM_NODES] ;
  float disp;
  
  for (x_count=0; x_count<NUM_NODES; x_count++)
  {
    aNode = arrayNodes.get(x_count);
    x_dof = 2*(aNode.Number-1);
    y_dof = x_dof+1;
    
    load_vector[x_dof] = aNode.XLoad;
    load_vector[y_dof] = aNode.YLoad;
  }
  
  MaxDisplacement = 0.0;
  for (x_count=0; x_count<NUM_NODES; x_count++)
  {
    aNode = arrayNodes.get(x_count);
    x_dof = 2*(aNode.Number-1);
    y_dof = x_dof+1;
    
    aNode.XDisplacement = 0.0;
    aNode.YDisplacement = 0.0;
    for (y_count=0; y_count<2*NUM_NODES; y_count++)
    {
      aNode.XDisplacement += stiffness_matrix_inverse[x_dof][y_count]*load_vector[y_count];
      aNode.YDisplacement += stiffness_matrix_inverse[y_dof][y_count]*load_vector[y_count];
    }
    disp = sqrt(aNode.XDisplacement*aNode.XDisplacement + aNode.YDisplacement*aNode.YDisplacement);
    if (disp>MaxDisplacement) MaxDisplacement = disp;
  }
  
}

void SolveForces()
{
  int x_dof, y_dof, x_count, y_count;
  Line aLine;
  Node nStart, nEnd;
  
  for (int count=0; count<NUM_LINES; count++)
  {
    aLine = arrayLines.get(count);
    nStart = arrayNodes.get(aLine.NodeStart);
    nEnd = arrayNodes.get(aLine.NodeEnd);
    aLine.Force = YoungsModulus*aLine.Area/(aLine.XLength*aLine.XLength+aLine.YLength*aLine.YLength);
    aLine.Force *= aLine.XLength*(nEnd.XDisplacement-nStart.XDisplacement) + aLine.YLength*(nEnd.YDisplacement-nStart.YDisplacement);
  }
}


void OutputNodes()
{
  //  Output Nodes for Debug
  println("\n\nNODES :");
  for (Node aNode : arrayNodes)
  {
    println("\nNumber       = "+aNode.Number);
    println("Coord        = ("+aNode.XCoord+","+aNode.YCoord+")");
    println("Fixity       = ("+aNode.XFixed+","+aNode.YFixed+")");
    println("Load         = ("+aNode.XLoad+","+aNode.YLoad+")");
    println("Displacement = ("+aNode.XDisplacement+","+aNode.YDisplacement+")");
  }
}
  
void OutputLines()
{
  
  //  Output Nodes for Debug
  println("\n\nLINES :");
  for (Line aLine : arrayLines)
  {
    println("\nNumber       = "+aLine.Number);
    println("Nodes        = "+aLine.NodeStart+" --> "+aLine.NodeEnd);
    println("Length       = ("+aLine.XLength+","+aLine.YLength+")");
    println("Force        = "+aLine.Force);
  }
}
  
void OutputMatrix()
{
  int row, col;
  
  //  Output Matrix for Debug
  print("\n");
  for (row=0; row<2*NUM_NODES; row++)
  {
    for (col=0; col<2*NUM_NODES; col++) print("  "+nfs(stiffness_matrix[row][col], 5, 1));
    print("\n");
  }
  
  //  Output Matrix for Debug
  print("\n");
  for (row=0; row<2*NUM_NODES; row++)
  {
    for (col=0; col<2*NUM_NODES; col++) print("  "+nfs(stiffness_matrix_inverse[row][col], 5, 1));
    print("\n");
  }
}
  


    
void mousePressed()
{
  Mouse_OldX = mouseX;
  Mouse_OldY = mouseY;
}
void mouseDragged()
{
  Mouse_X = mouseX;
  Mouse_Y = mouseY;
  
  switch (mouseButton)
  {
    case LEFT :
      RotateX_Drag = PI*(Mouse_X-Mouse_OldX)/width;
      RotateY_Drag = -PI*(Mouse_Y-Mouse_OldY)/height;
      break;
    case RIGHT :
      PanX_Drag = 100*(Mouse_X-Mouse_OldX)/width;
      PanY_Drag = 100*(Mouse_Y-Mouse_OldY)/height;
      break;
    case CENTER :
      Zoom_Drag = -100*(Mouse_Y-Mouse_OldY)/height;
      break;
  }
}
void mouseReleased()
{
  switch (mouseButton)
  {
    case LEFT :
      RotateX += RotateX_Drag;
      RotateY += RotateY_Drag;
      RotateX_Drag = 0.0;
      RotateY_Drag = 0.0;
      break;
    case RIGHT :
      PanX += PanX_Drag;
      PanY += PanY_Drag;
      PanX_Drag = 0.0;
      PanY_Drag = 0.0;
      break;
    case CENTER :
      Zoom += Zoom_Drag;
      Zoom_Drag = 0.0;
      break;
  }
  if (RunDebug) println("Zoom ="+Zoom+"  PanX ="+PanX+"  PanY ="+PanY);
}


void draw() 
{ 
  background(0.0, 0.0, 0.0);
  //lights();
  strokeWeight(1);
  
  float zoomFac = Zoom+Zoom_Drag;
  if (zoomFac < 1.0) zoomFac = 1.0;
 
  
  pushMatrix(); 
 
  translate(PanX+PanX_Drag, PanY+PanY_Drag); 
  //rotateY(-RotateX-RotateX_Drag); 
  //rotateX(RotateY+RotateY_Drag); 
  
  DrawLines(zoomFac);
  DrawDisplacements(zoomFac);
  //DrawNodes(zoomFac);
  
  popMatrix(); 
  
  if (MaxDisplacement>0.0)
  {
      textFont(font, 24);
      fill(255,0,0);
      text("Displacement="+round(MaxDisplacement), 30, 300);
      fill(0,64,255);
      text("Weight="+round(TotalWeight), 600, 300); 
      fill(255,255,0);
      text("Cost="+round(Cost()), 320, 310); 
  }
  
  //if (Animation_Frame==Animation_Limit) save("c:\\Temp\\image.bmp");
} 

void DrawNodes(float zoomFac)
{
  Node aNode;
  
  strokeWeight(10);
  beginShape(POINTS);
    for (int count=0; count<NUM_NODES; count++)
    {
      aNode = arrayNodes.get(count);
      stroke(255*int(aNode.XFixed), 255*int(aNode.YFixed), 255);  //  White
      vertex(aNode.XCoord*zoomFac, aNode.YCoord*zoomFac);
    }
  endShape();
}

void DrawLines(float zoomFac)
{
  Node nStart, nEnd;
  
  stroke(0, 255, 255);  //  Cyan
    for (Line aLine : arrayLines)
    {
      nStart = arrayNodes.get(aLine.NodeStart);
      nEnd = arrayNodes.get(aLine.NodeEnd);
      
      strokeWeight(pow(aLine.Area, 0.6)+1);
      beginShape(LINES);
          vertex(nStart.XCoord*zoomFac, nStart.YCoord*zoomFac);
          vertex(nEnd.XCoord*zoomFac, nEnd.YCoord*zoomFac);
      endShape();
    }
}

void DrawDisplacements(float zoomFac)
{
  Node nStart, nEnd;
  float anim_scale;
  
  if ((Animation_Frame==Animation_Limit)||(Animation_Frame==0)) Animation_Increment = -Animation_Increment;
  Animation_Frame += Animation_Increment;
  anim_scale = 0.025*float(Animation_Frame)/Animation_Limit;
  
  stroke(255, 0, 0);  //  Red
  strokeWeight(1);
  beginShape(LINES);
    for (Line aLine : arrayLines)
    {
      nStart = arrayNodes.get(aLine.NodeStart);
      nEnd = arrayNodes.get(aLine.NodeEnd);
      vertex((nStart.XCoord+nStart.XDisplacement*anim_scale)*zoomFac, (nStart.YCoord+nStart.YDisplacement*anim_scale)*zoomFac);
      vertex((nEnd.XCoord+nEnd.XDisplacement*anim_scale)*zoomFac, (nEnd.YCoord+nEnd.YDisplacement*anim_scale)*zoomFac);
    }
  endShape();

}

