/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.macosx;

import com.jogamp.common.util.Function;
import com.jogamp.common.util.FunctionTask;
import com.jogamp.common.util.RunnableTask;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.ToolkitProperties;

public class OSXUtil
implements ToolkitProperties {
    private static boolean isInit = false;
    private static final boolean DEBUG = Debug.debug("OSXUtil");
    private static Runnable _nop = new Runnable(){

        @Override
        public void run() {
        }
    };

    public static synchronized void initSingleton() {
        if (!isInit) {
            if (DEBUG) {
                System.out.println("OSXUtil.initSingleton()");
            }
            if (!NWJNILibLoader.loadNativeWindow("macosx")) {
                throw new NativeWindowException("NativeWindow MacOSX native library load error.");
            }
            if (!OSXUtil.initIDs0()) {
                throw new NativeWindowException("MacOSX: Could not initialized native stub");
            }
            isInit = true;
        }
    }

    public static void shutdown() {
    }

    public static boolean requiresToolkitLock() {
        return false;
    }

    public static final boolean hasThreadingIssues() {
        return false;
    }

    public static boolean isNSView(long l) {
        return OSXUtil.isNSView0(l);
    }

    public static boolean isNSWindow(long l) {
        return OSXUtil.isNSWindow0(l);
    }

    public static Point GetLocationOnScreen(long l, boolean bl, int n, int n2) {
        Point point = (Point)OSXUtil.GetLocationOnScreen0(l, n, n2);
        if (bl) {
            Insets insets = OSXUtil.GetInsets(l);
            point.setX(point.getX() + insets.getLeftWidth());
            point.setY(point.getY() + insets.getTopHeight());
        }
        return point;
    }

    public static Insets GetInsets(long l) {
        return (Insets)OSXUtil.GetInsets0(l);
    }

    public static long CreateNSWindow(int n, int n2, int n3, int n4) {
        return OSXUtil.CreateNSWindow0(n, n2, n3, n4);
    }

    public static void DestroyNSWindow(long l) {
        OSXUtil.DestroyNSWindow0(l);
    }

    public static long GetNSView(long l) {
        return OSXUtil.GetNSView0(l);
    }

    public static long GetNSWindow(long l) {
        return OSXUtil.GetNSWindow0(l);
    }

    public static long CreateCALayer(final int n, final int n2, final int n3, final int n4) {
        return OSXUtil.RunOnMainThread(true, new Function<Long, Object>(){

            public Long eval(Object ... objectArray) {
                return OSXUtil.CreateCALayer0(n, n2, n3, n4);
            }
        }, new Object[0]);
    }

    public static void AddCASublayer(final long l, final long l2) {
        if (0L == l || 0L == l2) {
            throw new IllegalArgumentException("rootCALayer 0x" + Long.toHexString(l) + ", subCALayer 0x" + Long.toHexString(l2));
        }
        OSXUtil.RunOnMainThread(true, new Runnable(){

            @Override
            public void run() {
                OSXUtil.AddCASublayer0(l, l2);
            }
        });
    }

    public static void FixCALayerPosition(final long l, final long l2, final int n, final int n2) {
        if (0L == l && 0L == l2) {
            return;
        }
        OSXUtil.RunOnMainThread(false, new Runnable(){

            @Override
            public void run() {
                OSXUtil.FixCALayerPosition0(l, l2, n, n2);
            }
        });
    }

    public static void RemoveCASublayer(final long l, final long l2) {
        if (0L == l || 0L == l2) {
            throw new IllegalArgumentException("rootCALayer 0x" + Long.toHexString(l) + ", subCALayer 0x" + Long.toHexString(l2));
        }
        OSXUtil.RunOnMainThread(true, new Runnable(){

            @Override
            public void run() {
                OSXUtil.RemoveCASublayer0(l, l2);
            }
        });
    }

    public static void DestroyCALayer(final long l) {
        if (0L == l) {
            throw new IllegalArgumentException("caLayer 0x" + Long.toHexString(l));
        }
        OSXUtil.RunOnMainThread(true, new Runnable(){

            @Override
            public void run() {
                OSXUtil.DestroyCALayer0(l);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RunOnMainThread(boolean bl, Runnable runnable) {
        if (OSXUtil.IsMainThread0()) {
            runnable.run();
        } else {
            Throwable throwable = null;
            Object object = new Object();
            RunnableTask runnableTask = new RunnableTask(runnable, bl ? object : null, true);
            Object object2 = object;
            synchronized (object2) {
                OSXUtil.RunOnMainThread0((Runnable)runnableTask);
                if (bl) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throwable = interruptedException;
                    }
                    if (null == throwable) {
                        throwable = runnableTask.getThrowable();
                    }
                    if (null != throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }
        }
    }

    public static void WaitUntilFinish() {
        OSXUtil.RunOnMainThread(true, _nop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, A> R RunOnMainThread(boolean bl, Function<R, A> function, A ... AArray) {
        if (OSXUtil.IsMainThread0()) {
            return (R)function.eval((Object[])AArray);
        }
        Throwable throwable = null;
        Object object = new Object();
        FunctionTask functionTask = new FunctionTask(function, bl ? object : null, true);
        Object object2 = object;
        synchronized (object2) {
            functionTask.setArgs((Object[])AArray);
            OSXUtil.RunOnMainThread0((Runnable)functionTask);
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = functionTask.getThrowable();
                }
                if (null != throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
        return (R)functionTask.getResult();
    }

    public static boolean IsMainThread() {
        return OSXUtil.IsMainThread0();
    }

    public static int GetScreenRefreshRate(int n) {
        return OSXUtil.GetScreenRefreshRate0(n);
    }

    private static native boolean initIDs0();

    private static native boolean isNSView0(long var0);

    private static native boolean isNSWindow0(long var0);

    private static native Object GetLocationOnScreen0(long var0, int var2, int var3);

    private static native Object GetInsets0(long var0);

    private static native long CreateNSWindow0(int var0, int var1, int var2, int var3);

    private static native void DestroyNSWindow0(long var0);

    private static native long GetNSView0(long var0);

    private static native long GetNSWindow0(long var0);

    private static native long CreateCALayer0(int var0, int var1, int var2, int var3);

    private static native void AddCASublayer0(long var0, long var2);

    private static native void FixCALayerPosition0(long var0, long var2, int var4, int var5);

    private static native void RemoveCASublayer0(long var0, long var2);

    private static native void DestroyCALayer0(long var0);

    private static native void RunOnMainThread0(Runnable var0);

    private static native boolean IsMainThread0();

    private static native int GetScreenRefreshRate0(int var0);
}

