/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.newt.event.InputEvent;

public class KeyEvent
extends InputEvent {
    private final short keyCode;
    private final short keySym;
    private final char keyChar;
    private final byte flags;
    private static final byte F_MODIFIER_MASK = 1;
    private static final byte F_ACTION_MASK = 2;
    private static final byte F_NON_PRINT_MASK = 3;
    public static final short EVENT_KEY_PRESSED = 300;
    public static final short EVENT_KEY_RELEASED = 301;
    public static final short EVENT_KEY_TYPED = 302;
    public static final short VK_CANCEL = 3;
    public static final short VK_BACK_SPACE = 8;
    public static final short VK_TAB = 9;
    public static final short VK_ENTER = 10;
    public static final short VK_CLEAR = 12;
    public static final short VK_SHIFT = 16;
    public static final short VK_CONTROL = 17;
    public static final short VK_ALT = 18;
    public static final short VK_PAUSE = 19;
    public static final short VK_CAPS_LOCK = 20;
    public static final short VK_ESCAPE = 27;
    public static final short VK_SPACE = 32;
    public static final short VK_PAGE_UP = 33;
    public static final short VK_PAGE_DOWN = 34;
    public static final short VK_END = 35;
    public static final short VK_HOME = 36;
    public static final short VK_LEFT = 37;
    public static final short VK_UP = 38;
    public static final short VK_RIGHT = 39;
    public static final short VK_DOWN = 40;
    public static final short VK_COMMA = 44;
    public static final short VK_MINUS = 45;
    public static final short VK_PERIOD = 46;
    public static final short VK_SLASH = 47;
    public static final short VK_0 = 48;
    public static final short VK_1 = 49;
    public static final short VK_2 = 50;
    public static final short VK_3 = 51;
    public static final short VK_4 = 52;
    public static final short VK_5 = 53;
    public static final short VK_6 = 54;
    public static final short VK_7 = 55;
    public static final short VK_8 = 56;
    public static final short VK_9 = 57;
    public static final short VK_SEMICOLON = 59;
    public static final short VK_EQUALS = 61;
    public static final short VK_A = 65;
    public static final short VK_B = 66;
    public static final short VK_C = 67;
    public static final short VK_D = 68;
    public static final short VK_E = 69;
    public static final short VK_F = 70;
    public static final short VK_G = 71;
    public static final short VK_H = 72;
    public static final short VK_I = 73;
    public static final short VK_J = 74;
    public static final short VK_K = 75;
    public static final short VK_L = 76;
    public static final short VK_M = 77;
    public static final short VK_N = 78;
    public static final short VK_O = 79;
    public static final short VK_P = 80;
    public static final short VK_Q = 81;
    public static final short VK_R = 82;
    public static final short VK_S = 83;
    public static final short VK_T = 84;
    public static final short VK_U = 85;
    public static final short VK_V = 86;
    public static final short VK_W = 87;
    public static final short VK_X = 88;
    public static final short VK_Y = 89;
    public static final short VK_Z = 90;
    public static final short VK_OPEN_BRACKET = 91;
    public static final short VK_BACK_SLASH = 92;
    public static final short VK_CLOSE_BRACKET = 93;
    public static final short VK_NUMPAD0 = 96;
    public static final short VK_NUMPAD1 = 97;
    public static final short VK_NUMPAD2 = 98;
    public static final short VK_NUMPAD3 = 99;
    public static final short VK_NUMPAD4 = 100;
    public static final short VK_NUMPAD5 = 101;
    public static final short VK_NUMPAD6 = 102;
    public static final short VK_NUMPAD7 = 103;
    public static final short VK_NUMPAD8 = 104;
    public static final short VK_NUMPAD9 = 105;
    public static final short VK_MULTIPLY = 106;
    public static final short VK_ADD = 107;
    public static final short VK_SEPARATOR = 108;
    public static final short VK_SUBTRACT = 109;
    public static final short VK_DECIMAL = 110;
    public static final short VK_DIVIDE = 111;
    public static final short VK_DELETE = 127;
    public static final short VK_NUM_LOCK = 144;
    public static final short VK_SCROLL_LOCK = 145;
    public static final short VK_F1 = 112;
    public static final short VK_F2 = 113;
    public static final short VK_F3 = 114;
    public static final short VK_F4 = 115;
    public static final short VK_F5 = 116;
    public static final short VK_F6 = 117;
    public static final short VK_F7 = 118;
    public static final short VK_F8 = 119;
    public static final short VK_F9 = 120;
    public static final short VK_F10 = 121;
    public static final short VK_F11 = 122;
    public static final short VK_F12 = 123;
    public static final short VK_F13 = -4096;
    public static final short VK_F14 = -4095;
    public static final short VK_F15 = -4094;
    public static final short VK_F16 = -4093;
    public static final short VK_F17 = -4092;
    public static final short VK_F18 = -4091;
    public static final short VK_F19 = -4090;
    public static final short VK_F20 = -4089;
    public static final short VK_F21 = -4088;
    public static final short VK_F22 = -4087;
    public static final short VK_F23 = -4086;
    public static final short VK_F24 = -4085;
    public static final short VK_PRINTSCREEN = 154;
    public static final short VK_INSERT = 155;
    public static final short VK_HELP = 156;
    public static final short VK_META = 157;
    public static final short VK_BACK_QUOTE = 192;
    public static final short VK_QUOTE = 222;
    public static final short VK_KP_UP = 224;
    public static final short VK_KP_DOWN = 225;
    public static final short VK_KP_LEFT = 226;
    public static final short VK_KP_RIGHT = 227;
    public static final short VK_DEAD_GRAVE = 128;
    public static final short VK_DEAD_ACUTE = 129;
    public static final short VK_DEAD_CIRCUMFLEX = 130;
    public static final short VK_DEAD_TILDE = 131;
    public static final short VK_DEAD_MACRON = 132;
    public static final short VK_DEAD_BREVE = 133;
    public static final short VK_DEAD_ABOVEDOT = 134;
    public static final short VK_DEAD_DIAERESIS = 135;
    public static final short VK_DEAD_ABOVERING = 136;
    public static final short VK_DEAD_DOUBLEACUTE = 137;
    public static final short VK_DEAD_CARON = 138;
    public static final short VK_DEAD_CEDILLA = 139;
    public static final short VK_DEAD_OGONEK = 140;
    public static final short VK_DEAD_IOTA = 141;
    public static final short VK_DEAD_VOICED_SOUND = 142;
    public static final short VK_DEAD_SEMIVOICED_SOUND = 143;
    public static final short VK_AMPERSAND = 150;
    public static final short VK_ASTERISK = 151;
    public static final short VK_QUOTEDBL = 152;
    public static final short VK_LESS = 153;
    public static final short VK_GREATER = 160;
    public static final short VK_BRACELEFT = 161;
    public static final short VK_BRACERIGHT = 162;
    public static final short VK_AT = 512;
    public static final short VK_COLON = 513;
    public static final short VK_CIRCUMFLEX = 514;
    public static final short VK_DOLLAR = 515;
    public static final short VK_EURO_SIGN = 516;
    public static final short VK_EXCLAMATION_MARK = 517;
    public static final short VK_INVERTED_EXCLAMATION_MARK = 518;
    public static final short VK_LEFT_PARENTHESIS = 519;
    public static final short VK_NUMBER_SIGN = 520;
    public static final short VK_PLUS = 521;
    public static final short VK_RIGHT_PARENTHESIS = 522;
    public static final short VK_UNDERSCORE = 523;
    public static final short VK_WINDOWS = 524;
    public static final short VK_CONTEXT_MENU = 525;
    public static final short VK_FINAL = 24;
    public static final short VK_CONVERT = 28;
    public static final short VK_NONCONVERT = 29;
    public static final short VK_ACCEPT = 30;
    public static final short VK_MODECHANGE = 31;
    public static final short VK_KANA = 21;
    public static final short VK_KANJI = 25;
    public static final short VK_ALPHANUMERIC = 240;
    public static final short VK_KATAKANA = 241;
    public static final short VK_HIRAGANA = 242;
    public static final short VK_FULL_WIDTH = 243;
    public static final short VK_HALF_WIDTH = 244;
    public static final short VK_ROMAN_CHARACTERS = 245;
    public static final short VK_ALL_CANDIDATES = 256;
    public static final short VK_PREVIOUS_CANDIDATE = 257;
    public static final short VK_CODE_INPUT = 258;
    public static final short VK_JAPANESE_KATAKANA = 259;
    public static final short VK_JAPANESE_HIRAGANA = 260;
    public static final short VK_JAPANESE_ROMAN = 261;
    public static final short VK_KANA_LOCK = 262;
    public static final short VK_INPUT_METHOD_ON_OFF = 263;
    public static final short VK_CUT = -47;
    public static final short VK_COPY = -51;
    public static final short VK_PASTE = -49;
    public static final short VK_UNDO = -53;
    public static final short VK_AGAIN = -55;
    public static final short VK_FIND = -48;
    public static final short VK_PROPS = -54;
    public static final short VK_STOP = -56;
    public static final short VK_COMPOSE = -224;
    public static final short VK_ALT_GRAPH = -130;
    public static final short VK_BEGIN = -168;
    public static final short VK_UNDEFINED = 0;

    public KeyEvent(short s, Object object, long l, int n, short s2, short s3, char c) {
        super(s, object, l, n);
        this.keyCode = s2;
        this.keySym = s3;
        this.keyChar = c;
        byte by = 0;
        if (KeyEvent.isModifierKey(s3)) {
            by = (byte)(by | 1);
        }
        if (KeyEvent.isActionKey(s3)) {
            by = (byte)(by | 2);
        }
        this.flags = by;
    }

    public final char getKeyChar() {
        return this.keyChar;
    }

    public final short getKeySymbol() {
        return this.keySym;
    }

    public final short getKeyCode() {
        return this.keyCode;
    }

    @Override
    public final String toString() {
        return this.toString(null).toString();
    }

    @Override
    public final StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("KeyEvent[").append(KeyEvent.getEventTypeString(this.getEventType())).append(", code ").append(KeyEvent.toHexString(this.keyCode)).append(", sym ").append(KeyEvent.toHexString(this.keySym)).append(", char '").append(this.keyChar).append("' (").append(KeyEvent.toHexString((short)this.keyChar)).append("), isModifierKey ").append(this.isModifierKey()).append(", isActionKey ").append(this.isActionKey()).append(", ");
        return super.toString(stringBuilder).append("]");
    }

    public static String getEventTypeString(short s) {
        switch (s) {
            case 300: {
                return "EVENT_KEY_PRESSED";
            }
            case 301: {
                return "EVENT_KEY_RELEASED";
            }
            case 302: {
                return "EVENT_KEY_TYPED";
            }
        }
        return "unknown (" + s + ")";
    }

    public static boolean isModifierKey(short s) {
        switch (s) {
            case -130: 
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                return true;
            }
        }
        return false;
    }

    public final boolean isModifierKey() {
        return 0 != (1 & this.flags);
    }

    public static boolean isActionKey(short s) {
        if (112 <= s && s <= -4085 || 256 <= s && s <= 263 || -47 <= s && s <= -56) {
            return true;
        }
        switch (s) {
            case -224: 
            case -168: 
            case 3: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 127: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 524: 
            case 525: {
                return true;
            }
        }
        return false;
    }

    public final boolean isActionKey() {
        return 0 != (2 & this.flags);
    }

    public static boolean isPrintableKey(short s) {
        return !KeyEvent.isModifierKey(s) && !KeyEvent.isActionKey(s);
    }

    public final boolean isPrintableKey() {
        return 0 == (3 & this.flags);
    }
}

