function [Qmean,stderr,cost] = mc(T,u0bar,eps,M,N)
% MC simulation to find mean and variance for pred-prey system

du0 = eps*(2*rand(N,2)-1);
Q = zeros(1,N);

for j=1:N
    
    u0 = u0bar + du0(j,:);
    u = pp_euler(T,u0,M);
    
    Q(j) = u(1);
    
end

Qmean = mean(Q);
Qvar = var(Q);

stderr = sqrt(Qvar/N); 

cost = 8*N*M;

end
