/*
 * timer.hh
 *
 *  Created on: 2013. 9. 2.
 *      Author: parkmh
 */

#ifndef TIMER_HH_
#define TIMER_HH_

#define TIME_SIZE 40
#include <ctime>
//#include <cstdio>
#include <sys/time.h>
#include <iostream>


class Timer{
public:
	Timer(){}
	void tic(){ gettimeofday(&time_,NULL); }
	void toc();
	double getTime();
	void timestamp();

private:
	timeval time_;
};

void Timer::toc(){
	double start_time_sec = (double)time_.tv_sec;
	double start_time_usec = (double)time_.tv_usec;

	gettimeofday(&time_,NULL);
	std::cout << "Elapsed time is " <<
			(((double)time_.tv_sec - start_time_sec)*1000000 + ((double)time_.tv_usec - start_time_usec))/1000000
			<<" seconds." <<  std::endl;
}

double Timer::getTime(){
	double start_time_sec = (double)time_.tv_sec;
	double start_time_usec = (double)time_.tv_usec;

	gettimeofday(&time_,NULL);
	return (((double)time_.tv_sec - start_time_sec)*1000000 + ((double)time_.tv_usec - start_time_usec))/1000000;
}

void Timer::timestamp(){
	static char time_buffer[TIME_SIZE];
	const struct std::tm *tm_ptr;
	std::time_t now;

	now = std::time ( NULL );
	tm_ptr = std::localtime ( &now );

	std::strftime ( time_buffer, TIME_SIZE, "%d %B %Y %I:%M:%S %p", tm_ptr );

	std::cout << time_buffer << "\n";
}


#endif /* TIMER_HH_ */
