/*
 * element.hh
 *
 *  Created on: 2013. 7. 27.
 *      Author: parkmh
 */

/*
 * Changelog
 	 * v.0.1 Added element.hh
 	 *
 */

#ifndef ELEMENT_HH_
#define ELEMENT_HH_

#include <vector>
#include <ostream>
#include <stdexcept>

template <int dim, int node> class Element;
typedef Element<2,3> Triangle;
typedef Element<2,4> Quadrilatral;
typedef Element<3,4> Tetrahedra;
typedef Element<3,8> Cube;
typedef Element<3,6> Prism;

template <int dim, int node> class Element:public std::vector<int>{
public:
	static const int NNode = node;
	static const int Dim = dim;

	Element(){  this->resize(node);}
	int& operator[](size_t n){
		return this->at(n);
	}
	const int& operator[](size_t n) const{
		return this->at(n);
	}
	friend std::ostream&
	operator<<(std::ostream& os, const Element &e){
		os << "[(nnodes=" << e.size() << ")";
		for (size_t i = 0; i < e.size(); i++)
			os << ", " << e[i];
		os << "]";
		return os;
	}

};
//
//class Element{
//public:
//	Element(size_t); 	// default constructor
//	Element(const Element&);
//	Element& operator=(const Element&);
//
//	void pushback(const int &);
//	void clear(){ nodes.clear(); }
//
//	friend std::ostream&
//	operator<<(std::ostream& os, const Element &e){
//		os << "[(nnodes=" << e.nnode << ")";
//		for (size_t i = 0; i < e.nnode; i++)
//			os << ", " << e.nodes[i];
//		os << "]";
//		return os;
//	}
//
//private:
//	size_t nnode;
//	std::vector< int > nodes;
//};
//
//Element::Element(size_t nnode_in = 0):nnode(nnode_in){
//	if (nnode > 0) nodes.reserve(nnode);
//}
//
//Element::Element(const Element &e){
//	nnode = e.nnode;
//	nodes = e.nodes;
//}
//
//Element& Element::operator=(const Element &e){
//	if (this != &e){
//		nnode = e.nnode;
//		nodes = e.nodes;
//	}
//	return *this;
//}
//void Element::pushback(const int &node){
//	nodes.push_back(node);
//	nnode = nodes.size();
//}



#endif /* ELEMENT_HH_ */
