/*
 * cnumvec_op.hh
 *
 *  Created on: 2013. 10. 7.
 *      Author: parkmh
 */

#ifndef CNUMVEC_OP_HH_
#define CNUMVEC_OP_HH_

#include "../math/complex_full_matrix.hh"
#include "numvec.hh"
#include <complex>
#include <random>



template <typename T>
void rand(NumVec<std::complex<T> >& x){
	NumVec<T> real, imag;
	real.resize(x.size());
	imag.resize(x.size());

	real.rand();
	imag.rand();
	for (size_t i = 0 ; i < x.size(); i++){
		x[i] = std::complex<T>(real[i],imag[i]);
	}
}

template <typename T>
void randn(NumVec<std::complex<T> >& x){
	NumVec<T> real, imag;
	real.resize(x.size());
	imag.resize(x.size());

	real.randn();
	imag.randn();
	for (size_t i = 0 ; i < x.size(); i++){
		x[i] = std::complex<T>(real[i],imag[i]);
	}
}

template <typename T>
void ke1le2ey(const CFMatrix<T>& K,
				const NumVec<std::complex<T> > &e1,
				const FMatrix<T>& L,
				const NumVec<std::complex<T> >&e2,
				NumVec<std::complex<T> >& y){
	size_t nrow = L.row();
	size_t kncol = K.col();
	y.resize(nrow);

	size_t i, j;
	std::complex<T> sum1, sum2;
	for (i = 0; i < nrow; i++){
		sum1 = sum2 = 0.0;
		for (j = 0; j < kncol; j++){
			sum1 += K(i,j)*e1[j];
		}
		for (j = 0; j < i+1; j++){
			sum2 += L(i,j)*e2[j];
		}
		y[i] = sum1+sum2;
	}

}
#endif /* CNUMVEC_OP_HH_ */
