/*
 * covariance_functions.hh
 *
 *  Created on: 2013. 12. 15.
 *      Author: Minho Park
 */

#ifndef COVARIANCE_FUNCTIONS_HH_
#define COVARIANCE_FUNCTIONS_HH_
#include <cmath>



template <typename T>
struct ExpCov{
	const T sigma2 = 1.0;
	const T lambda = 0.3;
	T operator()(const T& r) {
		return sigma2*(T)exp(-r/lambda);
	}
	std::string Description() const {
		std::ostringstream convert1, convert2;
		convert1 << sigma2;
		convert2 << lambda;
		std::string description = "Exponential [sigma2 = "
				                 + convert1.str() + ", lambda = " + convert2.str() + "]";
		return description;
	}
};


template <typename T>
struct GaussCov{
	const T sigma2 = 1.0;
	const T lambda = 0.3;
	T operator()(const T& r) {
		return sigma2*(T)exp(-r*r/(lambda*lambda));
	}
	std::string Description() const {
		std::ostringstream convert1, convert2;
		convert1 << sigma2;
		convert2 << lambda;
		std::string description = "Gaussian [sigma2 = "
				                 + convert1.str() + ", lambda = " + convert2.str() + "]";
		return description;
	}
};


//template <typename T>
//struct MaternCov{
//	const T sigma2 = 1.0;
//	const T lambda = 0.3;
//	T operator()(const T& r) {
//		return sigma2*(T)exp(-r*r/(lambda*lambda));
//	}
//	std::string Description() const {
//		std::ostringstream convert1, convert2;
//		convert1 << sigma2;
//		convert2 << lambda;
//		std::string description = "Gaussian [sigma2 = "
//				                 + convert1.str() + ", lambda = " + convert2.str() + "]";
//		return description;
//	}
//};


#endif /* COVARIANCE_FUNCTIONS_HH_ */
