/*
 * crs_matrix2.hh
 *
 *  Created on: 2013. 9. 9.
 *      Author: parkmh
 */

#ifndef CRS_MATRIX2_HH_
#define CRS_MATRIX2_HH_

#ifndef NUMVEC_HH_
#include "numvec.hh"
#endif
#include <vector>
template <class T>
class CRSMatrix{
private: class Element;
public:
	typedef T datatype;
	typedef Element * iterator;
	typedef const Element * const_iterator;
	typedef std::vector<Element> rowContainer;
	CRSMatrix();
	~CRSMatrix(){ delete [] pRowContainer_; }

	// function for iterator
	rowContainer *begin() 		{ return &pRowContainer_[0]; }
	const rowContainer *begin() { return &pRowContainer_[0]; }
	rowContainer *end() 			{ return &pRowContainer_[size_]; }
	const rowContainer *end() 	{ return &pRowContainer_[size_]; }

private:
	class Element{
		T value() const {return value_;}
		size_t column() const {return column_;}
	private:
		T value_;
		size_t column_;
	};
	rowContainer *pRowContainer_;
	size_t size_;
};




#endif /* CRS_MATRIX2_HH_ */
