/*
 * restriction.hh
 *
 *  Created on: 2013. 8. 15.
 *      Author: parkmh
 */

#ifndef RESTRICTION_HH_
#define RESTRICTION_HH_

#include "../util/config.hh"
#include "../math/crs_matrix.hh"
#include <iostream>


template <class CRSMAT>
class Restriction{
public:
	typedef typename CRSMAT::data_type data_type;
	Restriction(){ A_ = NULL;}

	virtual ~Restriction() {};
	virtual void init(const CRSMAT&, const INTP<CRSMAT>&) = 0;
	virtual void print(std::ostream&) const = 0;
	virtual void shorten(NumVec<data_type> &,const NumVec<data_type> &) const = 0;
	const CRSMatrix<data_type>* operator() ()const { return &PT_;}
	friend std::ostream&
	operator<<(std::ostream& os, const Restriction& pt){
		pt.print(os);
		return os;
	}

protected:
	const CRSMatrix<data_type> *A_;
	CRSMatrix<data_type> PT_;
};

#endif /* RESTRICTION_HH_ */
