/*
 * relaxation_bgs.hh
 *
 *  Created on: 2013. 8. 15.
 *      Author: parkmh
 */
/*
 * Changelog
 * v.0.1 Added relaxation_bgs.hh.
 *
 */
#ifndef RELAXATION_BGS_HH_
#define RELAXATION_BGS_HH_

#include "relaxation.hh"
#include <iostream>
template <class CRSMAT>
class BGS : public Relaxation<CRSMAT>{
public:
	typedef typename CRSMAT::datatype datatype;
	BGS();
	BGS(const CRSMAT& , size_t);
	void init(const CRSMAT& , size_t);
	void solve(const NumVec<datatype> &, NumVec<datatype> &x) const;
	void print(std::ostream&) const;
private:
	const CRSMAT *A;
	double w;
};

template <class CRSMAT >
BGS<CRSMAT>::BGS()
{
	A = NULL;
	w = 0.0;
}

template <class CRSMAT >
BGS<CRSMAT>::BGS(const CRSMAT&a, size_t niter = 1)
{ init(a,niter);}

template <class CRSMAT >
void BGS<CRSMAT> ::init(const CRSMAT&a, size_t niter = 1)
{
	this->A_ = &a;
	this->n_ = a.row();
	this->niter_ = niter;
	A = (this->A_);
	w = RELAX_WEIGHT;
}

template <class CRSMAT >
void BGS<CRSMAT> ::solve(const NumVec<datatype>& rhs, NumVec<datatype> &x) const {
	if (A->col() != x.size()){
		std::cerr << "??? error using ==> bgs \n Dimension of both matrix and vector must agree \n";
		exit(0);
	}
	datatype var, d;
	size_t ajaj, iai,iaip1, nRow, nRowm1;
	nRow = this->n_;
	nRowm1 = nRow-1;
	double wc = 1-w;
	if (w == 1.0){
		for (int iter = 0; iter < this->niter_; iter++){
			iaip1 = A->ia(nRow);
			for( int i = nRowm1; i >= 0; i-- )
			{
				iai = A->ia(i);
				var = 0;
				d = datatype();
				for( size_t j = iai; j < iaip1; j ++ )
				{
					ajaj = A->ja( j );
					if( i != ajaj )
					{
						var += A->aa( j ) * x[ ajaj ];
					}
					else
					{
						d = A->aa( j );
					}
				}
				iaip1 = iai;
				x[ i ] = ( rhs[ i ] - var )/ d;
			}
		}
	}
	else {
		for (int iter = 0; iter < this->niter_; iter++){
			iaip1 = A->ia(nRow);
			for( int i = nRowm1; i >= 0; i-- )
			{
				iai = A->ia(i);
				var = 0;
				d = datatype();
				for( size_t j = iai; j < iaip1; j ++ )
				{
					ajaj = A->ja( j );
					if( i != ajaj )
					{
						var += A->aa( j ) * x[ ajaj ];
					}
					else
					{
						d = A->aa( j );
					}
				}
				iaip1 = iai;
				x[ i ] = w*( rhs[ i ] - var )/ d + wc*x[ i ];
			}
		}
	}
}

template <class CRSMAT >
void BGS<CRSMAT> ::print(std::ostream& os) const {
	if (w == 1.0){
		os << "Backward Gauss Seidel [niter = "
				<< this->niter_ <<"]";
	} else{
		os << "Backward SOR [niter = "
				<< this->niter_ <<", w = " << w<<"]";
	}
}


#endif /* RELAXATION_BGS_HH_ */
