/*
 * relaxation.hh
 *
 *  Created on: 2013. 8. 7.
 *      Author: parkmh
 */
/*
 * Changelog
 	 * v.0.1 Added relaxation.hh.
 	 *
 */

#ifndef RELAXATION_HH_
#define RELAXATION_HH_

#include "../math/numvec.hh"
#include "../math/crs_matrix.hh"
#include "../util/config.hh"

// Abstract data type for relaxation
template <class CRSMAT>
class Relaxation{
protected:
	const CRSMAT *A_;
	size_t n_;
	size_t niter_;
public:
	typedef typename CRSMAT::data_type data_type;
	Relaxation() { A_ = NULL; niter_ = 0; n_ = 0;}
	Relaxation(const CRSMAT &A, size_t niter = 1): A_(&A), n_(A.row()), niter_(niter){};
	void set_niter(size_t niter) {niter_ = niter;}
	size_t niter() {return niter_;}
	double residual( const NumVec<data_type> &rhs, const NumVec<data_type> &x) const;
	virtual void solve(const NumVec<data_type> &rhs, NumVec<data_type> &x	) const = 0;
	virtual void init(const CRSMAT& , size_t) = 0;
	virtual ~Relaxation() {}
	virtual void print(std::ostream&) const = 0;
	friend std::ostream& operator<<(std::ostream& os, const Relaxation & r){
		r.print(os);
		return os;
	}
};

template <class CRSMAT>
double Relaxation<CRSMAT>::residual(const NumVec<data_type> & rhs, const NumVec<data_type> & x) const{
	NumVec<data_type> r(rhs);
	r -= (*A_)*x;
	return (rhs-*(A_)*x).l2norm();
}
#endif /* RELAXATION_HH_ */
