/*
 * csn_amgcsn.hh
 *
 *  Created on: 2013. 8. 15.
 *      Author: parkmh
 */

/*
 * Changelog
 * v.0.1 Added csn_amgcsn.hh.
 *
 */
#ifndef CSN_AMGCSN_HH_
#define CSN_AMGCSN_HH_

#define CPOINT 1
#define FPOINT 0

#define UNUSED -1
#define LAST   -2
#define FIRST  -2

#include "csn.hh"

template <typename T>
class AMGCSN:public CSN<T>{
public:
	typedef T datatype;
	AMGCSN();
	AMGCSN(const CRSMatrix<T> &);
	void init(const CRSMatrix<T> &);

	const size_t& rows(size_t n) const { return RowS_[n];}
	const size_t& cols(size_t n) const { return ColS_[n];}
	void print(std::ostream & ) const;
protected:
	const CRSMatrix<T> *A;
	double theta_;

	NumVec<size_t> RowS_, ColS_, RowST_, ColST_;
	NumVec< int > nofconnection_;

	void strong_connection();
	void first_coloring();
	void second_coloring();
};

template <typename T>
AMGCSN<T>::AMGCSN(){
	A = NULL;
	theta_ = 0.0;
}

template <typename T>
AMGCSN<T>::AMGCSN(const CRSMatrix<T> &a){
	init(a);
}

template <typename T>
void AMGCSN<T>::init(const CRSMatrix<T>& a){
	this->A_ = &a;
	A = (this->A_);
	this->nf_ = A->row();
	nofconnection_.resize(A->row());
	nofconnection_ = 0;
	theta_ = THETA;
	this->C_.resize(this->nf_);
	this->C_ = false;

	strong_connection();
	first_coloring();
	second_coloring();
	this->compute_nc();
}

template <typename T>
void AMGCSN<T>::strong_connection(){
	size_t i, j, nrow, nnz, iai, iaip1, ajaj;
	int index = 0;

	size_t nsti;
	double maxval, posAij;

	nrow = A->row();
	nnz = A->nnz();

	RowS_.resize(nrow+1);
	ColS_.resize(nnz-nrow);
	RowST_.resize(nrow+1);
	ColST_.resize(nnz-nrow);

	NumVec<int> nST(nrow);
	int * nstp = nST.begin();

//	std::vector< std::vector< size_t > > jjt(nrow);
	std::vector< NumVec< size_t > > jjt(nrow);

	const size_t * iap = A->iabegin();
	const size_t * jap = A->jabegin();
	const T* aap = A->aabegin();

	iai = *iap;//A->ia(0);
	for (i = 0; i < nrow; i++) {
		iaip1 = *(iap+i+1);//A->ia(i+1);
		jjt[ i ].resize(iaip1-iai);

		iai = iaip1;
	}

	size_t * rowsp = RowS_.begin();
	size_t * rowstp = RowST_.begin();
	size_t * colsp = ColS_.begin();
	size_t * colstp = ColST_.begin();
	int * nofcp = nofconnection_.begin();
	*rowsp = 0;
//	RowS_[ 0 ] = 0;

	iai = *iap;//A->ia(0);

	for (i = 0; i < nrow; i++){
		maxval = 0.0;
		iaip1 = *(iap+i+1);//A->ia(i+1);
		for (j = iai; j < iaip1; j++) {
			posAij = fabs(*(aap+j));
			if ( (i != *(jap+j)) & (maxval < posAij)) maxval = posAij;
		}

		for (j = iai; j < iaip1; j++) {
			posAij = fabs(*(aap+j));
			ajaj = *(jap+j);
			if ( (i != ajaj) & (posAij > maxval * theta_)) {
				*(colsp + index) = ajaj;
				(*(nofcp+i))++;
				jjt[ ajaj ][ *(nstp+ ajaj) ] = i;
				(*(nstp+ajaj))++;//++nST[ ajaj ]++;
				index++;
			}
		}

		*(rowsp+i+1) = index;
		iai = iaip1;
	}

	*rowstp = 0;
	index = 0;

	for (i = 0; i < nrow; i++){
		nsti = *(nstp + i);//nST[ i ];
		for (j = 0; j < nsti; j++){
			*(colstp+index)	= jjt[ i ][ j ];
			index++;
		}
		*(rowstp+i+1) = *(rowstp+i) + nsti;
	}

	nofconnection_ += nST;
}

template <typename T>
void AMGCSN<T>::first_coloring(){
	int max_lambda = 0;
	int lambda;

	size_t i;
	size_t assigned_index = 0; // The number of assigned nodes.
	int temp_index;
	int max_index;
	int j;
	size_t k,l, nRow, colsk, colstj, rowscolstj,rowscolstjp1;
	int rowstmax, rowstmaxp1;
	int nofccolsk, nofccolstj;
	int next_index_colstj, prev_index_colstj;
	int next_index_colsk, prev_index_colsk;
	int next_index_max_index, prev_index_max_index;
	int first_index_nofccolsk;

	nRow = this->nf_;


	NumVec< int > prev_index(nRow,UNUSED);
	NumVec< int > next_index(nRow,UNUSED);
	size_t size_first_index = nRow;
	if ((int)nRow < nofconnection_.max())
		size_first_index = nofconnection_.max();
	NumVec< int > first_index(size_first_index,UNUSED);


	int * nofcp = nofconnection_.begin();
	size_t* rowsp = RowS_.begin();
	size_t* rowstp = RowST_.begin();
	size_t* colsp = ColS_.begin();
	size_t* colstp = ColST_.begin();
	int* prevp = prev_index.begin();
	int* nextp = next_index.begin();
	int* firstp = first_index.begin();
	// Initialize the double linked list, and update max_lambda
	for (i = 0; i < nRow; i++) {
		lambda = *(nofcp+i);//nofconnection_[ i ];

		if (lambda > 0) {
			if (max_lambda < lambda) { // Update maximum lambda value
				max_lambda = lambda;
			}
			if (first_index[ lambda ] == UNUSED) { // First new node
				first_index[ lambda ] = i;
				*(prevp + i) = FIRST;
				*(nextp + i) = LAST;
			} else { // Add new node
				*(prevp+ *(firstp+ lambda) ) = i ;
				*(nextp+i ) = *(firstp + lambda );

				*(prevp+ i ) = FIRST;
				*(firstp+ lambda) = i;
			}
		}
	}

	/*=====================
	   First Coloring Pass
	  =====================*/
	while (assigned_index != nRow) {
		if (max_lambda > 0) {
			max_index = *(firstp + max_lambda );
			temp_index = max_index;

			while (*(nextp +temp_index ) != LAST) {
				if (max_index > *(nextp + temp_index)) {
					max_index = *(nextp + temp_index );
				}
				temp_index = *(nextp +temp_index );
			} // end while
		}// end if
		else {
			for (l = 0; l < nRow; l++) {
				if (*(nofcp+  l) != UNUSED)
					this->C_[ l ] = CPOINT;
			} // end for loop l
			break;
		} // end else

#ifdef AMG_CSN_DEBUG
		cout << endl << "**********" << endl;
		cout << max_index << "[C]" << endl;
		cout << "**********" << endl;
#endif
		this->C_[ max_index ] = CPOINT;
		*(nofcp+max_index ) = UNUSED;
		assigned_index += 1;

		// delete node from the list
		if (*(nextp + max_index ) == LAST) { // Last index of list
			if (*(prevp + max_index ) == FIRST) { // First index of list
#ifdef AMG_CSN_DEBUG
				cout << "----- " << first_index[ max_lambda ] << " is the only index in [" << max_lambda << "]" << endl;
#endif
				*(firstp + max_lambda) = UNUSED;
				max_lambda--;
				while (*(firstp + max_lambda) == UNUSED) {
					if (max_lambda == 0)
						break;
					max_lambda--;
				} // end while
#ifdef AMG_CSN_DEBUG
				cout << "Max Lambda : " << max_lambda << endl;
#endif
			}// end if ( prev...)
			else { // Last index of list of size > 1
#ifdef AMG_CSN_DEBUG
				cout << "----- " << max_index << " is the last index in [" << max_lambda << "]" << endl;
#endif
				*(nextp +  *(prevp + max_index) ) = LAST;
			} // end else
		}// end if ( next... )
		else {
			if (*(prevp + max_index) == FIRST) { // First index of list of size > 1
#ifdef AMG_CSN_DEBUG
				cout << "----- " << max_index << " is the first index in [" << max_lambda << "]" << endl;
#endif
				next_index_max_index = *(nextp +  max_index );
				*(firstp + max_lambda ) = next_index_max_index;
				*(prevp + next_index_max_index ) = FIRST;
			}// end if ( prev...)
			else { // index in the middle of list of size > 1
				prev_index_max_index = *(prevp + max_index );
				*(prevp +  *(nextp + max_index) ) = prev_index_max_index;
				*(nextp + prev_index_max_index ) = *(nextp + max_index );
			} // end else
		} // end else

		// Make pointers of max_index Null
		*(prevp +  max_index ) = UNUSED;
		*(nextp +  max_index ) = UNUSED;

#ifdef AMG_CSN_DEBUG
		cout << endl;
		for (i = 0; i < nRow; i++) {
			if (*(firstp + i ) != UNUSED){
				temp_index = *(first_index+i);
				cout << "nofc[" << i << "] : " << temp_index ;
				while (*(nextp + temp_index) != LAST){
					cout << " => " << next_index[temp_index];
					temp_index = next_index[temp_index];
				}
				cout << endl;
			}
		}
#endif

		// Set unassigned points which strongly depend on max_index to be F point
		rowstmax = *(rowstp+max_index);
		rowstmaxp1 = *(rowstp+max_index+1);
		for (j = rowstmax; j < rowstmaxp1; j++) {
			colstj = *(colstp+j);
			nofccolstj = *(nofcp + colstj);
			if (nofccolstj > 0) {
				// Delete node jt(j)
				if (*(nextp +  colstj ) == LAST) { // Last index of list
					if (*(prevp + colstj ) == FIRST) { // First index of list
						*(firstp + nofccolstj ) = UNUSED;
						while (*(firstp + max_lambda ) == UNUSED) {
							max_lambda--;
							if (max_lambda == 0)
								break;
						} // end while
					}// end if
					else { // Last index of list of size > 1
						*(nextp +  *(prevp + colstj ) ) = LAST;
					}
				}// end if (next...)
				else {
					if (*(prevp + colstj) == FIRST) { // First index of list of size > 1
						next_index_colstj = *(nextp + colstj );
						*(firstp + nofccolstj ) = next_index_colstj;
						*(prevp + next_index_colstj ) = FIRST;
					} else {
						prev_index_colstj = *(prevp + colstj );
						*(prevp + *(nextp +  colstj ) ) = prev_index_colstj;
						next_index[ prev_index_colstj ] = next_index[ colstj ];
					}
				} // end else

#ifdef AMG_CSN_DEBUG
				cout << "----- " << colstj << "[F]" << endl;
#endif
				// Make pointers of max index NULL
				*(prevp + colstj) = UNUSED;
				*(nextp + colstj) = UNUSED;
				// Assign jt(j) to be F point
				*(nofcp + colstj ) = UNUSED;
				assigned_index++;

				// Check nbds of jt(j)
				rowscolstj = *(rowsp + colstj );
				rowscolstjp1 = *(rowsp + colstj + 1 );
				for (k = rowscolstj; k < rowscolstjp1; k++) {
					colsk = *(colsp + k);
					nofccolsk = *(nofcp + colsk);
					if (nofccolsk > 0) {
#ifdef AMG_CSN_DEBUG
						cout << "----- " << colsk << " => " << "nofc[" << nofc[ colsk ] + 1 << "]" << endl;
#endif
						// Delete js(k) from list of nofc(js(k))
						if (*(nextp + colsk ) == LAST) { // Last index of list
							if (*(prevp + colsk ) == FIRST) { // First index of list
								*(firstp + nofccolsk ) = UNUSED;
							} else {
								*(nextp + *(prevp + colsk ) ) = LAST;
							}
						} else {
							if (*(prevp + colsk) == FIRST) {
								next_index_colsk = *(nextp + colsk );
								*(firstp + nofccolsk ) = next_index_colsk;
								*(prevp +  next_index_colsk ) = FIRST;
							} else {
								prev_index_colsk = *(prevp +  colsk );
								*(prevp+ *(nextp + colsk ) ) = prev_index_colsk;
								*(nextp +  prev_index_colsk ) = *(nextp + colsk );
							}
						}

						// Increase the number of connection by 1
						(*(nofcp + colsk))++;

						// Update max_lambda
						nofccolsk++;
						if (nofccolsk > max_lambda) {
							max_lambda = nofccolsk;
						}
						// Insert index to new list
						if (*(firstp + nofccolsk ) == UNUSED) {
							*(firstp +  nofccolsk ) = colsk;
							*(prevp + colsk ) = FIRST;
							*(nextp + colsk ) = LAST;
						} else {
							first_index_nofccolsk = *(firstp + nofccolsk );
							*(prevp + first_index_nofccolsk ) = colsk;
							*(nextp + colsk ) = first_index_nofccolsk;

							*(prevp +  colsk ) = FIRST;
							*(firstp + nofccolsk ) = colsk;
						}
					} // end if (nofc...)
				} // end loop k
			} // end if
		} // end loop j
#ifdef AMG_CSN_DEBUG
		cout << endl;
		for (i = 0; i < nRow; i++) {
			if (first_index[ i ] != UNUSED){
				temp_index = first_index[i];
				cout << "nofc[" << i << "] : " << temp_index ;
				while (next_index[temp_index] != LAST){
					cout << " => " << next_index[temp_index];
					temp_index = next_index[temp_index];
				}
				cout << endl;
			}
		}
#endif
	} // end while
}

template <typename T>
void AMGCSN<T>::second_coloring(){
	int is2ndFF = 0;
	int isNot2C = 0;
	int temp_index = 0;
	size_t jj;
	double a_ki;
	size_t i,k,colsk, colsj, rowscolsj, rowscolsjp1, aiacolsk, aiacolskp1;

//	int j;
	size_t j;
	size_t rowsi, rowsip1;

	const size_t* iap = A->iabegin();
	const size_t* jap = A->jabegin();
	const T* aap = A->aabegin();
	size_t * rowsp = RowS_.begin();
	size_t * colsp = ColS_.begin();
	rowsi = *rowsp;//RowS_[0];
	for (i = 0; i < this->nf_; i++) {
		rowsip1 = *(rowsp+i+1);//RowS_[ i + 1 ];
		if (this->C_[ i ] == FPOINT) { // For an F-point i
			is2ndFF = 0;
			// Points that strongly influence to i
			for (j = rowsi; j < rowsip1; j++) {
				colsj = *(colsp + j);//ColS_[ j ];
				if (this->C_[ colsj ] == FPOINT && i != colsj) {
					isNot2C = 1;
					rowscolsj = *(rowsp+ colsj );
					rowscolsjp1 = *(rowsp +  colsj + 1 );
					for (k = rowscolsj; k < rowscolsjp1; k++) {
						colsk = *(colsp + k);//ColS_[ k ];
						if (this->C_[ colsk ] == CPOINT && colsk != i) {
							a_ki = 0.0;
							aiacolsk = *(iap + colsk);
							aiacolskp1 = *(iap + colsk+1);
							for (jj = aiacolsk; jj < aiacolskp1; jj++) {
								if (*(jap + jj)  == i) {
									a_ki = *(aap + jj);
								}
							}
							if (a_ki != 0.0) {
								isNot2C = 0;
								break;
							}
						}
					} // end loop k

					if (isNot2C == 1 && is2ndFF == 1) {
						this->C_[ i ] = CPOINT;
						this->C_[ temp_index ] = FPOINT;
						break;
					}

					if (isNot2C == 1 && is2ndFF == 0) {
						is2ndFF = 1;
						temp_index = *(colsp + j);//ColS_[ j ];
						this->C_[ temp_index ] = CPOINT;
					} // end if

				} // end if
			} // end loop j
		} // end if
		rowsi = rowsip1;
	} // end for loop i
}

template <typename T>
void AMGCSN<T>::print(std::ostream& os) const{
	os << "AMG Coarsening [theta = " << this->theta_ << ", nf = "
			<< this->nf_ <<", nc = " << this->nc_ <<"]";
}

#endif /* CSN_AMGCSN_HH_ */
