/*
 * mc_traits.hh
 *
 *  Created on: 2013. 8. 20.
 *      Author: parkmh
 */

#ifndef MC_TRAITS_HH_
#define MC_TRAITS_HH_

#include "cem_traits.hh"
#include "../../cem/cem.hh"
#include "fvm_traits.hh"
#include "../../fvm/fvm.hh"
#include "../../iter/amg_traits.hh"
#include "../../iter/amg.hh"
#include "../../iter/pcg.hh"
#include "sampling_traits.hh"
#include "../../qoi/qoi_outflux.hh"


#ifndef MCTAGS
#define MCTAGS
struct mc1d_tag{};
struct mc2d_tag{};
struct mc3d_tag{};
#endif
template <typename T> struct exponential;
template <int dim, typename T> struct exponential2;
template <int dim, typename T> struct cgv_split;
template <class Category, typename T = void>
struct mc_traits{};

template <typename T>
struct mc_traits<mc1d_tag,T>{
	static const int dim = 1;
	typedef T			datatype;
	typedef CEM<cem1d_tag,T> rfgenerator;
	typedef FVM<fvm1d_tag,T> discretization;
	typedef AMG<amg_tag,T> 	preconditioner;
	typedef PCG<preconditioner> lsolver;
	typedef qoi_outflux<1,discretization> qoifun;
	typedef exponential<T> secondop;
	typedef exponential2<1,T> split;
	typedef sampling_traits<nocgv1d_tag,T> sampling;
};

template <typename T>
struct mc_traits<mc2d_tag,T>{
	static const int dim = 2;
	typedef T			datatype;
	typedef CEM<cem2d_tag,T> rfgenerator;
	typedef FVM<fvm2d_tag,T> discretization;
	typedef AMG<amg_tag,T> 	preconditioner;
	typedef PCG<preconditioner> lsolver;
	typedef qoi_outflux<2,discretization> qoifun;
	typedef exponential<T> secondop;
	typedef exponential2<2,T> split;
	typedef sampling_traits<nocgv2d_tag,T> sampling;
};

template <typename T>
struct mc_traits<mc3d_tag,T>{
	static const int dim = 3;
	typedef T			datatype;
	typedef CEM<cem3d_tag,T> rfgenerator;
	typedef FVM<fvm3d_tag,T> discretization;
	typedef AMG<amg3d_tag,T> 	preconditioner;
	typedef PCG<preconditioner> lsolver;
	typedef qoi_outflux<3,discretization> qoifun;
	typedef exponential<T> secondop;
	typedef exponential2<3,T> split;
	typedef sampling_traits<nocgv3d_tag,T> sampling;
};


template <typename T>
struct exponential{
	NumVec<T> operator()(const NumVec<T>& x) const{
		return exp<T>(x);
	}
};

template <int dim, typename T>
struct cgv_split{
	void operator()(const NumVec<T>& a, const Point<dim,size_t>& Nc, NumVec<T>& ac, int flag) const {
		size_t ac_size = Nc.prod();
		ac.resize(ac_size);
		if (dim == 1){
			if (flag == 1){
				for (size_t i = 0; i < Nc[0]; i++){
					ac[i] = a[i*2];
				}
			} else if (flag == 2){
				for (size_t i = 0; i < Nc[0]; i++){
					ac[i] = a[i*2+1];
				}
			}
		}
		else if (dim == 2){
			if (flag == 1){
				for (size_t j = 0; j < Nc[1]; j++){
					for (size_t i = 0; i < Nc[0]; i++){
						ac[j*Nc[0]+i] = a[4*Nc[0]*j + 2*i];
					}
				}
			} else if (flag == 2){
				for (size_t j = 0; j < Nc[1]; j++){
					for (size_t i = 0; i < Nc[0]; i++){
						ac[j*Nc[0]+i] = a[4*Nc[0]*j + 2*i+1];
					}
				}
			} else if (flag == 3){
				for (size_t j = 0; j < Nc[1]; j++){
					for (size_t i = 0; i < Nc[0]; i++){
						ac[j*Nc[0]+i] = a[4*Nc[0]*j +2*Nc[0]+ 2*i];
					}
				}
			} else if (flag == 4){
				for (size_t j = 0; j < Nc[1]; j++){
					for (size_t i = 0; i < Nc[0]; i++){
						ac[j*Nc[0]+i] = a[4*Nc[0]*j +2*Nc[0]+ 2*i+1];
					}
				}
			}
		}
		else if (dim == 3){
			if (flag == 1){
				for (size_t k = 0; k < Nc[2]; k++){
					for (size_t j = 0; j < Nc[1]; j++){
						for (size_t i = 0; i < Nc[0]; i++){
							ac[(k*Nc[1]+j)*Nc[0]+i] = a[(2*Nc[1]*2*k + 2*j)*2*Nc[0] + 2*i];
						}
					}
				}
			} else if (flag == 2){
				for (size_t k = 0; k < Nc[2]; k++){
					for (size_t j = 0; j < Nc[1]; j++){
						for (size_t i = 0; i < Nc[0]; i++){
							ac[(k*Nc[1]+j)*Nc[0]+i] = a[(2*Nc[1]*2*k + 2*j)*2*Nc[0] + 2*i+1];
						}
					}
				}
			} else if (flag == 3){
				for (size_t k = 0; k < Nc[2]; k++){
					for (size_t j = 0; j < Nc[1]; j++){
						for (size_t i = 0; i < Nc[0]; i++){
							ac[(k*Nc[1]+j)*Nc[0]+i] = a[(2*Nc[1]*2*k + 2*j)*2*Nc[0] + 2*i + 2*Nc[0]];
						}
					}
				}
			} else if (flag == 4){
				for (size_t k = 0; k < Nc[2]; k++){
					for (size_t j = 0; j < Nc[1]; j++){
						for (size_t i = 0; i < Nc[0]; i++){
							ac[(k*Nc[1]+j)*Nc[0]+i] = a[(2*Nc[1]*2*k + 2*j)*2*Nc[0] + 2*i + 2*Nc[0] + 1];
						}
					}
				}
			} else if (flag == 5){
				for (size_t k = 0; k < Nc[2]; k++){
					for (size_t j = 0; j < Nc[1]; j++){
						for (size_t i = 0; i < Nc[0]; i++){
							ac[(k*Nc[1]+j)*Nc[0]+i] = a[(2*Nc[1]*2*k + 2*j)*2*Nc[0] + 2*i + 4*Nc[0]*Nc[1]];
						}
					}
				}
			} else if (flag == 6){
				for (size_t k = 0; k < Nc[2]; k++){
					for (size_t j = 0; j < Nc[1]; j++){
						for (size_t i = 0; i < Nc[0]; i++){
							ac[(k*Nc[1]+j)*Nc[0]+i] = a[(2*Nc[1]*2*k + 2*j)*2*Nc[0] + 2*i + 4*Nc[0]*Nc[1]+1];
						}
					}
				}
			} else if (flag == 7){
				for (size_t k = 0; k < Nc[2]; k++){
					for (size_t j = 0; j < Nc[1]; j++){
						for (size_t i = 0; i < Nc[0]; i++){
							ac[(k*Nc[1]+j)*Nc[0]+i] = a[(2*Nc[1]*2*k + 2*j)*2*Nc[0] + 2*i + 4*Nc[0]*Nc[1]+2*Nc[0]];
						}
					}
				}
			} else if (flag == 8){
				for (size_t k = 0; k < Nc[2]; k++){
					for (size_t j = 0; j < Nc[1]; j++){
						for (size_t i = 0; i < Nc[0]; i++){
							ac[(k*Nc[1]+j)*Nc[0]+i] = a[(2*Nc[1]*2*k + 2*j)*2*Nc[0] + 2*i + 4*Nc[0]*Nc[1]+2*Nc[0]+1];
						}
					}
				}
			}
		}
	}

};
template <int dim, typename T>
struct exponential2{
	void operator()(const NumVec<T>&z, const Point<dim,size_t>& N, NumVec<T> &kf, NumVec<T>&kc) const{
		size_t DNx1, DNy1;

		if (dim == 1){
			kf.resize(N[0]);
			for (size_t i = 0; i < N[0]; i++){
				kf[i] = exp(z[2*i+1]);
			}
			kc.resize(N[0]/2);
			for (size_t i = 0; i < N[0]/2; i++){
				kc[i] = exp(z[4*i+2]);
			}
		}
		else if (dim == 2){
			DNx1 = 2*N[0]+1;
			kf.resize(N[0]*N[1]);
			for (size_t j = 0; j < N[1]; j++){
				for (size_t i = 0; i < N[0]; i++){
					kf[j*N[0]+i] = exp(z[(2*j+1)*DNx1+(2*i+1)]);
				}
			}
			kc.resize(N[0]*N[1]/4);
			for (size_t j = 0; j < N[1]/2; j++){
				for (size_t i = 0; i < N[0]/2; i++){
					kc[j*N[0]/2+i] = exp(z[(4*j+2)*DNx1+(4*i+2)]);
				}
			}
		}
		else if (dim == 3){
			DNx1 = 2*N[0]+1;
			DNy1 = 2*N[1]+1;
			size_t m  = 0;
			size_t ll1, jj1, bottom;
			kf.resize(N[0]*N[1]*N[2]);
			for (size_t l = 0; l < N[2]; l++){
				ll1 = 2*l+1;
				for (size_t j = 0; j < N[1]; j++){
					jj1 = 2*j+1;
					bottom = (DNy1*ll1+jj1)*DNx1;
					for (size_t i = 0; i < N[0]; i++){
						kf[m] = exp(z[bottom+(2*i+1)]);
						m++;
					}
				}
			}
			kc.resize(N[0]*N[1]*N[2]/8);
			m = 0;
			for (size_t l = 0; l < N[2]/2; l++){
				for (size_t j = 0; j < N[1]/2; j++){
					for (size_t i = 0; i < N[0]/2; i++){
						kc[m] = exp(z[(DNy1*(4*l+2)+(4*j+2))*DNx1 + (4*i+2)]);
						m++;
					}
				}
			}
		}
	}
};



#endif /* ONE_LEVEL_MC_TRAITS_HH_ */
