/*
 * listnd.hh
 *
 *  Created on: 2013. 8. 6.
 *      Author: parkmh
 */

#ifndef LISTND_HH_
#define LISTND_HH_

template< class NODETYPE > class List;		// forward declaration

template< class NODETYPE >
class ListNode {
	friend class List< NODETYPE >;	// make List a friend
public:
	ListNode( const NODETYPE & );	// constructor
	NODETYPE getData() const;		// return data in the node
	void setNextPtr( ListNode< NODETYPE> *);
	ListNode * getNextPtr( void ) { return nextPtr; }
private:
	NODETYPE data;							// data
	ListNode< NODETYPE > *nextPtr;	// next node in the list
};

// Constructor
template< class NODETYPE >
ListNode<NODETYPE>::ListNode( const NODETYPE &info )
: data ( info ), nextPtr( 0 ) {}

// Return a copy of the data in the node
template< class NODETYPE >
NODETYPE ListNode< NODETYPE >::getData() const { return data; }

template< class NODETYPE >
void ListNode< NODETYPE >::setNextPtr( ListNode< NODETYPE> *newNextPtr)
{
	nextPtr = newNextPtr;
}


#endif /* LISTND_HH_ */
