/*
 * exception.hh
 *
 *  Created on: 2013. 9. 20.
 *      Author: parkmh
 */

#ifndef EXCEPTION_HH_
#define EXCEPTION_HH_

#include <string>
#include <vector>

#include <iostream>

class NumeracyException{
public:
	NumeracyException();

	NumeracyException(const std::string& messe,
						const std::string& meth,
						const std::string& why);

	virtual ~NumeracyException() {}
	std::string message() const {return message_;}		// The message itself
	std::string rationale() const{return rationale_;} 	// Extra information
	std::string method() const {return method_;}			// In which method?

	// All information in one packet
	std::vector<std::string> messageDump() const {return result_;} 	// length 3

	// Print the full packet
	virtual void print() const;

private:
	std::string message_;		// The error message
	std::string method_;		// The method that threw the exception
	std::string rationale_;		// More info on message

	// Redundant data
	std::vector<std::string> result_;
};


NumeracyException::NumeracyException(){
	message_ = method_ = rationale_ = std::string();
	result_ = std::vector<std::string>(3);
	result_[0] = message_;
	result_[1] = method_;
	result_[2] = rationale_;
}

NumeracyException::NumeracyException(const std::string &mess,
										const std::string &meth, const std::string& why){
	message_ = mess;
	method_ = meth;
	rationale_ = why;
	result_ = std::vector<std::string>(3);
	result_[0] = message_;
	result_[1] = method_;
	result_[2] = rationale_;
}

void NumeracyException::print() const{
	// Variant part
	std::vector<std::string> r = messageDump();
	std::cout << std::endl << r[0] << std::endl;

	// Invariant part
	for (size_t j = 1; j < r.size(); j++){
		std::cout << '\t' << r[j] << std::endl;
	}
}
#endif /* EXCEPTION_HH_ */
