/*
 * sampling_traits.hh
 *
 *  Created on: 2013. 12. 11.
 *      Author: parkmh
 */
#include "../mesh/point.hh"

#ifndef SAMPLING_TRAITS_HH_
#define SAMPLING_TRAITS_HH_
struct nocgv1d_tag{};
struct nocgv2d_tag{};
struct nocgv3d_tag{};
struct cgv1d_tag{};
struct cgv2d_tag{};
struct cgv3d_tag{};

template <int dim, typename T> struct ShiftByPositiveHH;
template <int dim, typename T> struct ShiftByNegativeHH;
template <int dim, typename T> struct NoShift;
template <int dim> struct NM1;
template <int dim> struct DN;
template <int dim, typename T> struct ReturnH;
template <int dim, typename T> struct ReturnHH;

template<class Category, typename T = void>
struct sampling_traits{};

template<typename T>
struct sampling_traits<nocgv1d_tag,T>{
	const static int dim = 1;
	typedef T datatype;
	typedef ShiftByPositiveHH<dim,T> shift_start_onelevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_onelevel;
	typedef NoShift<dim,T> shift_start_twolevel;
	typedef NoShift<dim,T> shift_end_twolevel;
	typedef NM1<dim> nsamp_onelevel;
	typedef DN<dim>  nsamp_twolevel;
	typedef ReturnH<dim,T> h_onelevel;
	typedef ReturnHH<dim,T> h_twolevel;
};

template<typename T>
struct sampling_traits<nocgv2d_tag,T>{
	const static int dim = 2;
	typedef T datatype;
	typedef ShiftByPositiveHH<dim,T> shift_start_onelevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_onelevel;
	typedef NoShift<dim,T> shift_start_twolevel;
	typedef NoShift<dim,T> shift_end_twolevel;
	typedef NM1<dim> nsamp_onelevel;
	typedef DN<dim>  nsamp_twolevel;
	typedef ReturnH<dim,T> h_onelevel;
	typedef ReturnHH<dim,T> h_twolevel;
};

template<typename T>
struct sampling_traits<nocgv3d_tag,T>{
	const static int dim = 3;
	typedef T datatype;
	typedef ShiftByPositiveHH<dim,T> shift_start_onelevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_onelevel;
	typedef NoShift<dim,T> shift_start_twolevel;
	typedef NoShift<dim,T> shift_end_twolevel;
	typedef NM1<dim> nsamp_onelevel;
	typedef DN<dim>  nsamp_twolevel;
	typedef ReturnH<dim,T> h_onelevel;
	typedef ReturnHH<dim,T> h_twolevel;
};

template<typename T>
struct sampling_traits<cgv1d_tag,T>{
	const static int dim = 1;
	typedef T datatype;
	typedef ShiftByPositiveHH<dim,T> shift_start_onelevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_onelevel;
	typedef ShiftByPositiveHH<dim,T> shift_start_twolevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_twolevel;
	typedef NM1<dim> nsamp_onelevel;
	typedef NM1<dim>  nsamp_twolevel;
	typedef ReturnH<dim,T> h_onelevel;
	typedef ReturnH<dim,T> h_twolevel;
};

template<typename T>
struct sampling_traits<cgv2d_tag,T>{
	const static int dim = 2;
	typedef T datatype;
	typedef ShiftByPositiveHH<dim,T> shift_start_onelevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_onelevel;
	typedef ShiftByPositiveHH<dim,T> shift_start_twolevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_twolevel;
	typedef NM1<dim> nsamp_onelevel;
	typedef NM1<dim>  nsamp_twolevel;
	typedef ReturnH<dim,T> h_onelevel;
	typedef ReturnH<dim,T> h_twolevel;
};

template<typename T>
struct sampling_traits<cgv3d_tag,T>{
	const static int dim = 3;
	typedef T datatype;
	typedef ShiftByPositiveHH<dim,T> shift_start_onelevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_onelevel;
	typedef ShiftByPositiveHH<dim,T> shift_start_twolevel;
	typedef ShiftByNegativeHH<dim,T> shift_end_twolevel;
	typedef NM1<dim> nsamp_onelevel;
	typedef NM1<dim>  nsamp_twolevel;
	typedef ReturnH<dim,T> h_onelevel;
	typedef ReturnH<dim,T> h_twolevel;
};

template <int dim, typename T>
struct ShiftByPositiveHH{
	Point<dim,T> operator()(const Point<dim,T> &start, const Point<dim,T> h) const{
		Point<dim,T> hh = h;
		hh /= 2.0;
		return start + hh;
	}
};

template <int dim, typename T>
struct ShiftByNegativeHH{
	Point<dim,T> operator()(const Point<dim,T> &start, const Point<dim,T> h) const{
		Point<dim,T> hh = h;
		hh /= 2.0;
		return start - hh;
	}
};

template <int dim, typename T>
struct NoShift{
	Point<dim,T> operator()(const Point<dim,T> &start, const Point<dim,T> h) const{
		return start;
	}
};

template <int dim>
struct NM1{
	Point<dim,size_t> operator() (const Point<dim,size_t>& N) const {
		Point<dim,size_t> nm1 = N;
		nm1 -= 1;
		return nm1;
	}
};

template <int dim>
struct DN{
	Point<dim,size_t> operator() (const Point<dim,size_t>& N) const {
		Point<dim,size_t> dn = N;
		dn *= 2;
		return dn;
	}
};

template <int dim, typename T>
struct ReturnH{
	Point<dim,T> operator()(const Point<dim,T> &h) const{
		return h;
	}
};

template <int dim, typename T>
struct ReturnHH{
	Point<dim,T> operator()(const Point<dim,T> &h) const{
		return h/2.0;
	}
};

#endif /* SAMPLING_TRAITS_HH_ */
