/*
 * complex_full_matrix.hh
 *
 *  Created on: 2013. 9. 24.
 *      Author: parkmh
 */

#ifndef COMPLEX_FULL_MATRIX_HH_
#define COMPLEX_FULL_MATRIX_HH_

#define HERMITIAN 	"hermitian"
#include "full_matrix.hh"
#include <complex>
//#include <omp.h>

template <class T>
class CFMatrix : public FMatrix< std::complex<T> >{
public:
	CFMatrix() : FMatrix<std::complex<T> >(){};
	CFMatrix(const size_t nrow, const size_t ncol) : FMatrix<std::complex<T> >(nrow,ncol){};
	CFMatrix(const CFMatrix&, const char*);

	CFMatrix hermitian() const {return CFMatrix<T>(*this,"hermitian");}
	//	CFMatrix conjugate();
	void aah(CFMatrix<T>&) const;
	FMatrix<T> real() const;
	FMatrix<T> imag() const;
	const CFMatrix& operator=(const CFMatrix& );
};

template <class T>
CFMatrix<T>::CFMatrix(const CFMatrix<T> &A, const char*opt = DEFAULT){
	if (!strcmp(opt,DEFAULT)){
		this->nrow_ = A.nrow_;
		this->ncol_ = A.ncol_;

		this->create_container();

		for (size_t i = 0; i < this->nrow_; i++){
			for (size_t j = 0; j < this->ncol_; j++){
				this->value_[i][j] = A.value_[i][j];
			}
		}
	} else if (!strcmp(opt,TRANSPOSE)){
		this->nrow_ = A.ncol_;
		this->ncol_ = A.nrow_;
		this->create_container();

		for (size_t i = 0; i < this->nrow_; i++){
			for (size_t j = 0; j < this->ncol_; j++){
				this->value_[i][j] = A.value_[j][i];
			}
		}
	} else if (!strcmp(opt,HERMITIAN)){
		this->nrow_ = A.ncol_;
		this->ncol_ = A.nrow_;
		this->create_container();

		for (size_t i = 0; i < this->nrow_; i++){
			for (size_t j = 0; j < this->ncol_; j++){
				this->value_[i][j] = std::conj(A.value_[j][i]);
			}
		}
	}

}

template <class T>
const CFMatrix<T>& CFMatrix<T>::operator =(const CFMatrix<T> &rhs){
	if (this != &rhs){
		if (this->nrow_ != rhs.nrow_ | this->ncol_ != rhs.ncol_){
			this->delete_container();
			this->nrow_ = rhs.nrow_;
			this->ncol_ = rhs.ncol_;
			this->create_container();
		}
		for (size_t i = 0; i < this->nrow_; i++){
			std::copy(rhs.value_[i], rhs.value_[i]+this->ncol_, this->value_[i]);
		}
	}
	return *this;
}

template <class T>
FMatrix<T> CFMatrix<T>::real() const {
	FMatrix<T> Real;
	Real.resize(this->nrow_,this->ncol_);
	for (size_t i = 0; i < this->nrow_; i++){
		for (size_t j = 0; j < this->ncol_; j++){
			Real(i,j) = std::real( this->value_[i][j]);
		}
	}
	return Real;
}

template <class T>
FMatrix<T> CFMatrix<T>::imag() const {
	FMatrix<T> Imag;
	Imag.resize(this->nrow_,this->ncol_);
	for (size_t i = 0; i < this->nrow_; i++){
		for (size_t j = 0; j < this->ncol_; j++){
			Imag(i,j) = std::imag(this->value_[i][j]);
		}
	}
	return Imag;
}

template <class T>
CFMatrix<T> operator*(const CFMatrix<T>& A, const CFMatrix<T>& B){
	if (A.col()!= B.row()){
		throw std::out_of_range("Matrix size must agree(*).");
	}
	CFMatrix<T> C;
	C.resize(A.row(),B.col());
	for (size_t i = 0; i < A.row(); i++){
		for (size_t j = 0; j < B.col(); j++){
			C(i,j) = 0.0;
			for (size_t k = 0; k < A.col(); k++){
				C(i,j) += A(i,k) * B(k,j);
			}
		}
	}
	return C;
}
template <class T>
void CFMatrix<T>::aah(CFMatrix<T>& AAH) const {
	size_t n = this->nrow_;
	size_t m = this->ncol_;
	AAH.resize(n,n);
#pragma omp for
	for (size_t i = 0; i < n; i++){
		for (size_t j = 0; j < n; j++){

			AAH(i,j) = 0;
			for (size_t k = 0; k < m; k++)
				AAH(i,j) += this->value_[i][k]*std::conj(this->value_[j][k]);
		}
	}
}

#endif /* COMPLEX_FULL_MATRIX_HH_ */
