/*
 * pcg.hh
 *
 *  Created on: 2013. 8. 12.
 *      Author: parkmh
 */

#ifndef PCG_HH_
#define PCG_HH_

#include "krylov.hh"

template <class PCOND>
class PCG : public Krylov<PCOND>{
public:
	typedef typename PCOND::datatype datatype;
	typedef typename PCOND::matrix matrix;
	PCG();
	PCG(const matrix& , const PCOND &, size_t, double);
	~PCG();
	void init(const matrix& , const PCOND &, size_t,double);
	void solve(const NumVec<datatype> &, NumVec<datatype> &x) const;
	void print(std::ostream&) const;
private:
	const matrix *A;
	const PCOND * conditioner_;
	double* Residual_;

};

template <class PCOND>
PCG<PCOND>::PCG(){
	A = NULL;
	conditioner_ = NULL;
	Residual_ = NULL;
}

template <class PCOND>
PCG<PCOND>::PCG(const matrix& a, const PCOND & conditioner, size_t ncycle = 20, double tol = 1e-10){
	Residual_ = NULL;
	init(a,conditioner,ncycle,tol);
}

template <class PCOND>
void PCG<PCOND>::init(const matrix& a, const PCOND &conditioner, size_t ncycle = 20,double tol = 1e-10){
	this->A_ = &a;
	this->n_ = a.row();
	A = (this->A_);
	conditioner_ = &conditioner;
	this->ncycle_ = ncycle;
	this->tol_ = tol;
	delete[] Residual_;
	Residual_ = new double [this->ncycle_+1];
}

template <class PCOND>
PCG<PCOND>::~PCG(){
	delete [] Residual_;
}
template <class PCOND>
void PCG<PCOND>::solve(const NumVec<datatype>& rhs, NumVec<datatype> &v) const {
	this->lastcycle_ = this->ncycle_;

	NumVec< datatype > r; r.resize(rhs.size());
	bmaxey< datatype >(rhs, *A,v,r);

	Residual_[0] = r.l2norm();
	NumVec< datatype > z(A->row());
	conditioner_->solve(r,z);

	NumVec< datatype > p(z);
	datatype nu, alpha, beta;
	NumVec< datatype > Ap;
	Ap.resize(A->row());
	for (size_t i = 1; i <= this->ncycle_; i++) {
		nu = (r,z);
		axey<datatype>(*A,p,Ap);
		alpha = nu/(p,Ap);
//		v += (alpha*p);
		ypaxey<datatype>(v,alpha,p);

//		r -= (alpha*Ap);
		ymaxey<datatype>(r,alpha,Ap);
		Residual_[ i ] = r.l2norm();
//		if (printflag == 1){
//			printf("       %04ld.............................%.4e\n",i,Residual_[i]);
//		}
		if (Residual_[ i ] / Residual_[ 0 ]  < this->tol_) {
			this->lastcycle_ = i;
			break;
		}
		z = 0;

		conditioner_->solve(r,z);
		beta = (r,z)/nu;
//		p = z + beta*p;
		aypxey<datatype>(beta,p,z);

	}
}

template <class PCOND>
void PCG<PCOND>::print(std::ostream& os) const{
	os << "Preconditioned Conjugate Gradient" << std::endl;
	os << "[ PCG -> Preconditioner ] " << std::endl;
	if (conditioner_ == NULL)
		os << "not assigned yet." << std::endl;
	else
		conditioner_->overview(os);
}
#endif /* PCG_HH_ */
