/*
 * krylov.hh
 *
 *  Created on: 2013. 8. 12.
 *      Author: parkmh
 */

#ifndef KRYLOV_HH_
#define KRYLOV_HH_
#include "../math/numvec.hh"
#include <iostream>
template <class PCOND>
class Krylov{
public:
	typedef typename PCOND::datatype datatype;
	typedef typename PCOND::matrix matrix;
	Krylov() {A_=NULL; niter_ = 0; n_ = 0; pcond_ = NULL; tol_ = 0.0; ncycle_ = 0; lastcycle_ = 0;}
	Krylov(const matrix &A, const PCOND &pcond,
			size_t niter = 1, double tol = 1e-10,
			size_t ncycle = 20):
		A_(&A), n_(A.row()), pcond_(pcond),niter_(niter),
		tol_(tol), ncycle_(ncycle){ lastcycle_ = ncycle_;};
	void setIter(size_t niter) {niter_ = niter;}
	size_t getIter() {return niter_;}
	void setNcycle(size_t ncycle){ ncycle_ = ncycle;}
	size_t getNcycle() {return ncycle_;}
	void setTol(double tol) {tol_ = tol;}
	double getTol() {return tol_;}
	double residual( const NumVec<datatype> &rhs, const NumVec<datatype> &x) const;
	virtual void solve(const NumVec<datatype> &rhs, NumVec<datatype> &x	) const = 0;
	virtual ~Krylov() { };
	virtual void print (std::ostream &) const = 0;
	friend std::ostream&
	operator<<(std::ostream& os, const Krylov& krylov){
		krylov.print(os);
		return os;
	}
protected:
	const matrix *A_;
	const PCOND *pcond_;
	size_t n_;
	size_t niter_;
	size_t ncycle_;
	mutable size_t lastcycle_;
	double tol_;
};


#endif /* KRYLOV_HH_ */
