/*
 * interpolation_lramgp.hh
 *
 *  Created on: 2013. 8. 18.
 *      Author: parkmh
 */

#ifndef INTERPOLATION_LRL2AMGP_HH_
#define INTERPOLATION_LRAMGP_HH_

#include "interpolation.hh"

template <class CRSMAT>
class L2AMGP:public INTP<CRSMAT>{
public:
	typedef typename CRSMAT::data_type data_type;
	L2AMGP();
	L2AMGP(const CRSMatrix<data_type>&, CSN<data_type> &);
	void init(const CRSMatrix<data_type>&, CSN<data_type> &);
	void prolong(const NumVec<data_type> &, NumVec<data_type> &) const;
	void correct(const NumVec<data_type> &, NumVec<data_type> &) const;
	void print(std::ostream & ) const;
private:
	const CRSMatrix<data_type> *A;
	const CSN<data_type> *C;

	void computeP();
};

template <class CRSMAT>
L2AMGP<CRSMAT>::L2AMGP(){
	A = NULL;
	C = NULL;
}

template <class CRSMAT>
L2AMGP<CRSMAT>::L2AMGP(const CRSMatrix<data_type>&a, CSN<data_type> &c){
	init(a,c);
}

template <class CRSMAT>
void L2AMGP<CRSMAT>::init(const CRSMatrix<data_type>&a, CSN<data_type> &c){
	this->A_ = &a;
	C = &c;
	A = (this->A_);
	computeP();

}
template <class CRSMAT>
void L2AMGP<CRSMAT>::prolong(const NumVec<data_type> &x2h, NumVec<data_type> &xh) const{
	axey<data_type>(this->P_,x2h,xh);
}

template <class CRSMAT>
void L2AMGP<CRSMAT>::correct(const NumVec<data_type> &x2h, NumVec<data_type> &xh) const{
	axpyey<data_type>(this->P_,x2h,xh);
}

template <class CRSMAT>
void L2AMGP<CRSMAT>::print(std::ostream & os) const{
	os << "Length 2 AMG Interpolation [nf = "
			<< this->P_.row() <<", nc = " << this->P_.col() <<"]";
}

template <class CRSMAT>
void L2AMGP<CRSMAT>::computeP(){

	int MaxIndex = 0;
	int PIndex = 0;

	int i, j, k, l,Ci_index, ja_j,jak,alreadyexist;
	int aiai, aiaip1, inbdi, inbdip1, aiajnbdj, aiajnbdjp1;
	size_t max_cisize = 0;
	size_t cisize;

	int jnbdj;
	int m = A->row();
	NumVec< int > CArray(m);

	size_t *ip = new size_t[m + 1];

	for (i = 0; i < m; i++) {
		if (C->operator ()(i) == 1) {
			MaxIndex++;
		} else {
			MaxIndex += (C->rows(i+1) - C->rows(i));
		}

		if (i == 0) {
			if (C->operator()(i))
				CArray[ i ] = 1;
			else
				CArray[ i ] = 0;
		} else {
			if (C->operator()(i))
				CArray[ i ] = CArray[ i - 1 ] + 1;
			else
				CArray[ i ] = CArray[ i - 1 ];
		}
	}

	size_t *jp = new size_t[MaxIndex];
	data_type *ap = new data_type[MaxIndex];

	aiai = A->ia(0);
	inbdi = C->rows(0);
	ip[0] = 0;
	NumVec< int > Ci;
	NumVec< data_type > temp_Ci;

	for (i = 0; i < m; i++) {
		aiaip1  = A->ia(i+1);
		inbdip1 = C->rows(i+1);
		if (C->operator()(i)) // Make weight corresponding a C point be 1
		{
			ip[ i + 1 ] = ip[ i ] + 1;
			jp[ PIndex ] = CArray[ i ] - 1;
			ap[ PIndex ] = 1.0;
			PIndex++;
		} else // Calculate weight of C_i point for each F point i
		{
			cisize = inbdip1 - inbdi + aiaip1 - aiai;

			if (max_cisize < cisize){
				Ci.resize(cisize);
				temp_Ci.resize(cisize);
				max_cisize = cisize;
			}


			Ci_index = 0;


			// Discrimate Ci,Dsi and Dwi among neighborhood points
			for (j = aiai; j < aiaip1; j++) {
				ja_j = A->ja(j);
				if (C->operator()(ja_j) == 1) {
					Ci[ Ci_index ] = ja_j;
					jp[PIndex + Ci_index] = CArray[ja_j] - 1;
					Ci_index++;
				}
			} // end loop  j


			for (j = inbdi; j < inbdip1; j++) {
				jnbdj = C->cols(j);
				if (C->operator ()(jnbdj)) {
					Ci[ Ci_index ] = jnbdj;
					jp[PIndex + Ci_index] = CArray[jnbdj] -1;
					Ci_index++;
				}
			}

			if (Ci_index == 0){
				for (j = inbdi; j < inbdip1; j++) {
					jnbdj = C->cols(j);
					aiajnbdj = A->ia(jnbdj);
					aiajnbdjp1 = A->ia(jnbdj+1);
					for (k = aiajnbdj; k < aiajnbdjp1;k++){
						jak = A->ja(k);
						if (C->operator ()(jak) == 1) {
							alreadyexist = 0;
							for (l = 0; l < Ci_index; l++){
								if (jak == Ci[l]){
									alreadyexist = 1;
									break;
								}
							}
							if (!alreadyexist){
								Ci[ Ci_index ] = jak;
								jp[PIndex + Ci_index] = CArray[jak] -1;
								Ci_index++;
							}
						}
					}

				}
			}

			if (Ci_index == 0){
				std::cout << "No Ci points" <<std::endl;
				abort();
			}
			for (j= 0; j < Ci_index; j++){
				ap[PIndex + j ] = 1.0/(Ci_index);
			}

			ip[ i + 1 ] = ip[ i ] + Ci_index;
			PIndex += Ci_index;

		} // end else
		aiai = aiaip1;
		inbdi = inbdip1;
	}// end loop i


	this->P_.ia(ip,m+1);
	this->P_.ja(jp,PIndex);
	this->P_.aa(ap,PIndex);
	this->P_.setSize(m,CArray[m-1],PIndex);
	delete[] ip;
	delete[] jp;
	delete[] ap;
}



#endif /* INTERPOLATION_LRAMGP_HH_ */
