/*
 * interpolation_amgp.hh
 *
 *  Created on: 2013. 8. 15.
 *      Author: parkmh
 */

#ifndef INTERPOLATION_AMGP_HH_
#define INTERPOLATION_AMGP_HH_

#include "interpolation.hh"

template <class CRSMAT>
class AMGP:public INTP<CRSMAT>{
public:
	typedef typename CRSMAT::data_type data_type;
	AMGP();
	AMGP(const CRSMatrix<data_type>&, CSN<data_type> &);
	void init(const CRSMatrix<data_type>&, CSN<data_type> &);
	void prolong(const NumVec<data_type> &, NumVec<data_type> &) const;
	void correct(const NumVec<data_type> &, NumVec<data_type> &) const;
	void print(std::ostream & ) const;
private:
	const CRSMatrix<data_type> *A;
	const CSN<data_type> *C;

	void computeP();
};

template <class CRSMAT>
AMGP<CRSMAT>::AMGP(){
	A = NULL;
	C = NULL;
}

template <class CRSMAT>
AMGP<CRSMAT>::AMGP(const CRSMatrix<data_type>&a, CSN<data_type> &c){
	init(a,c);
}

template <class CRSMAT>
void AMGP<CRSMAT>::init(const CRSMatrix<data_type>&a, CSN<data_type> &c){
	this->A_ = &a;
	C = &c;
	A = (this->A_);
	computeP();

}
template <class CRSMAT>
void AMGP<CRSMAT>::prolong(const NumVec<data_type> &x2h, NumVec<data_type> &xh) const{
	axey<data_type>(this->P_,x2h,xh);
}

template <class CRSMAT>
void AMGP<CRSMAT>::correct(const NumVec<data_type> &x2h, NumVec<data_type> &xh) const{
	axpyey<data_type>(this->P_,x2h,xh);
}

template <class CRSMAT>
void AMGP<CRSMAT>::print(std::ostream & os) const{
	os << "AMG Interpolation [nf = "
			<< this->P_.row() <<", nc = " << this->P_.col() <<"]";
}

template <class CRSMAT>
void AMGP<CRSMAT>::computeP(){
	size_t nRow = A->row();

	size_t *ip = new size_t[nRow+1];

	int MaxIndex = 0;
	int PIndex = 0;

	size_t i, j, k, Ci_index, Dsi_index, ja_j, aiai, aiaip1, rowsi, rowsip1;
	size_t max_nbdsize = 0;
	size_t nbdsize;
	data_type a_i_k, a_k_j, bottom, bottom2;
	bool isIJStrong;

	NumVec < int > CArray(nRow);
	int * carrayp = CArray.begin();

	const size_t * iap = A->iabegin();
	const size_t * jap = A->jabegin();
	const data_type * aap = A->aabegin();

	aiai = *iap;//A->ia(0);
	for (i = 0; i < nRow; i++) {
		aiaip1 = *(iap+i+1);A->ia(i+1);
		if (C->operator()(i) == CPOINT) {
			MaxIndex += 1;
		} else {
			MaxIndex += (aiaip1 - aiai);
		}

		if (i == 0) {
			if (C->operator()(i))
				*(carrayp + i) = 1;
			else
				*(carrayp + i) = 0;
		} else {
			if (C->operator()(i))
				*(carrayp + i) = *(carrayp + i - 1) + 1;
			else
				*(carrayp + i) = *(carrayp + i - 1);
		}
		aiai = aiaip1;
	}

	size_t *jp = new size_t[MaxIndex];
	data_type *ap = new data_type[MaxIndex];


	NumVec< size_t > Ci;
	NumVec< size_t > Dsi;
	NumVec< data_type > temp_Ci;
	int dsik;
	aiai = *iap;//A->ia(0);
	*ip = 0;

	data_type* tempcip = temp_Ci.begin();
	size_t * cip = Ci.begin();
	size_t * dsip = Dsi.begin();
	for (i = 0; i < nRow; i++) {
		aiaip1  = *(iap+i+1);//A->ia(i+1);
		if (C->operator()(i) == CPOINT) // Make weight corresponding a C point be 1
		{
			*(ip+i + 1) = *(ip+ i) + 1;
			*(jp+PIndex) = *(carrayp + i) - 1;
			*(ap+PIndex) = 1.0;
			PIndex++;
		} else // Calculate weight of C_i point for each F point i
		{
			nbdsize = aiaip1 - aiai;
			if (max_nbdsize < nbdsize ){
				Ci.resize(nbdsize);
				Dsi.resize(nbdsize);

				temp_Ci.resize(nbdsize);
				temp_Ci = 0;
				tempcip = temp_Ci.begin();
				cip = Ci.begin();
				dsip = Dsi.begin();
				max_nbdsize = nbdsize;
			}

			Ci_index = 0;
			Dsi_index = 0;

			bottom2 = 0.0;

			// Discrimate Ci,Dsi and Dwi among neighborhood points
			for (j = aiai; j < aiaip1; j++) {
				ja_j = *(jap+j);//A->ja(j);
				if (C->operator()(ja_j) == 1) {
					*(cip + Ci_index) = ja_j;
					*(jp+PIndex + Ci_index) = *(carrayp + ja_j) - 1;
					*(ap+PIndex + Ci_index) = *(aap+j);//A->aa(j);
					Ci_index++;
				} else {
					isIJStrong = 0;
					rowsi = C->rows(i);
					rowsip1 = C->rows(i+1);
					for (k = rowsi; k < rowsip1; k++){
						if (C->cols(k) == ja_j){
							isIJStrong = 1;
							break;
						}
					}
					if (isIJStrong) {
						*(dsip+Dsi_index) = ja_j;
						Dsi_index += 1;
					} else if (i != ja_j) {
						//Dwi[ Dwi_index ] = ja_j;
						bottom2 += *(aap+j);//A->aa(j);
						//Dwi_index += 1;
					} else {
						bottom2 += *(aap+j);//A->aa(j);
					}
				}
			} // end loop  j


			// Calculate weight w_ij
			for (k = 0; k < Dsi_index; k++) {
				bottom = 0.0;
				dsik = *(dsip+k);
				a_i_k = A->get(i,dsik);

				for ( j = 0; j < Ci_index; j++) {
					a_k_j = A->get(dsik, *(cip+j));
					if (a_k_j != 0) {
						*(tempcip+j)  += a_i_k*a_k_j;
						bottom += a_k_j;
					}
				}
#ifdef LOOP_FISSION
				for ( j = 0; j < Ci_index; j++){
					ap[ PIndex + j] += *(tempcip+j) / bottom;
				}
				for ( j = 0; j < Ci_index; j++){
					*(tempcip+j) = 0.0;
				}
#else
				for ( j = 0; j < Ci_index; j++){
					ap[ PIndex + j] += *(tempcip+j) / bottom;
					*(tempcip+j) = 0.0;
				}
#endif
			}
			for (j = 0; j < Ci_index; j++) {
				*(ap+ PIndex + j ) = -*(ap+PIndex + j ) / bottom2;
			}
			*(ip+ i + 1) = *(ip+i) + Ci_index;
			PIndex += Ci_index;
		} // end else
		aiai = aiaip1;
	}// end loop i


	this->P_.ia(ip,nRow+1);
	this->P_.ja(jp,PIndex);
	this->P_.aa(ap,PIndex);
	this->P_.setSize(nRow,CArray[nRow-1],PIndex);
	delete[] ip;
	delete[] jp;
	delete[] ap;
}

#endif /* INTERPOLATION_AMGP_HH_ */
