/*
 * cell.hh
 *
 *  Created on: 2013. 12. 23.
 *      Author: parkmh
 */

#ifndef CELL_HH_
#define CELL_HH_
#include "node.hh"
template <class T, int N> class Cell{
public:
	Cell():index(-1){
		for (int i = 0; i < N; i++){
			vertex[i] = new Node<T>(0.,-1,1);
		}
	}// default constructor

	Cell(Node<T>&, Node<T>&, Node<T>&);
	Cell(Node<T>&, Node<T>&, Node<T>&, Node<T>&);

	Cell(const Cell<T,N>&);

	const Cell<T,N>& 	operator=(Cell<T,N>&);
	~Cell();

	Node<T>& operator() (int i){
		return *(vertex[i]);
	}	// read/writhe ith vertex

	const Node<T>& operator[] (int i) const {
		return *(vertex[i]);
	} // real only ith vertex

	void resetIndices(){
		for (int i = 0; i < N; i++){
			vertex[i]->setIndex(-1);
		}
	}

	void indexing(int &count){
		for (int i = 0; i < N;i++){
			if (vertex[i]->getIndex()<0)
				vertex[i]->setIndex(count++);
		}
	}	// indexing the vertices

	void setIndex(int i) { index = i; } // set the index of the cell to i

	int getIndex() const { return index; }; // read the index of the cell

	friend std::ostream&
	operator<<(std::ostream& os, const Cell &e){
		os << e[0];
		for (int i = 1; i < N; i++){
			os << ", " << e[i];
		}
		return os;
	}
protected:
	Node<T>* vertex[N];
	int index;
};

template<class T, int N>
Cell<T,N>::Cell(
		Node<T>&a, Node<T>&b, Node<T>&c):index(-1){
	vertex[0] = a.noSharingCells() ? new Node<T>(a) : &a;
	vertex[1] = b.noSharingCells() ? new Node<T>(b) : &b;
	vertex[2] = c.noSharingCells() ? new Node<T>(c) : &c;

	for (int i = 0; i < N; i++){
		vertex[i]->moreSharingCells();
	}
}	// constructor


template<class T, int N>
Cell<T,N>::Cell(
		Node<T>&a, Node<T>&b, Node<T>&c, Node<T>&d):index(-1){
	vertex[0] = a.noSharingCells() ? new Node<T>(a) : &a;
	vertex[1] = b.noSharingCells() ? new Node<T>(b) : &b;
	vertex[2] = c.noSharingCells() ? new Node<T>(c) : &c;
	vertex[3] = d.noSharingCells() ? new Node<T>(d) : &d;

	for (int i = 0; i < N; i++){
		vertex[i]->moreSharingCells();
	}
}	// constructor with 4 node arguments


template<class T, int N>
Cell<T,N>::Cell(const Cell<T,N>& e):index(e.index){
	for(int i = 0; i < N; i++){
		vertex[i] = e.vertex[i];
		vertex[i]->moreSharingCells();
	}
}	// copy constructor

template<class T, int N>
const Cell<T,N>&
	Cell<T,N>::operator=(Cell<T,N>&e){
	if (this != &e){
		index = e.index;
		for (int i = 0; i < N; i++){
			if (vertex[i]->lessSharingCells()){
				delete vertex[i];
			}
		}
		for (int i = 0; i < N; i++){
			vertex[i] =  e.vertex[i];
			vertex[i]->moreSharingCells();
		}
	}
	return *this;
}	// assignment operator

template <class T, int N>
Cell<T,N>::~Cell(){
	for (int i= 0; i < N; i++){
		if (vertex[i]->lessSharingCells()) delete vertex[i];
	}	// destructor
}

template <class T, int N>
int operator<(const Node<T>&n, const Cell<T,N>&e){
	for (int i = 0; i < N; i++){
		if (&n == &(e[i])) return i+1;
	}
	return 0;
}

template <class T, int N>
int operator&(const Cell<T,N>&e, const Cell<T,N>&f){
	for (int i = 1; i < N; i++){
		for (int j = 0; j < i; j++){
			if ((e[i] < f)&&(e[j]<f)) return 1;
		}
	}
	return 0;
}	// edge-sharing cell;s

typedef Cell<Pd2,3> Triangle;
typedef Cell<Pd2,4> Quadrilateral;
typedef Cell<Pd3,4> Tetrahedron;


#endif /* CELL_HH_ */
