/*
 * wipp.cpp
 *
 *  Created on: 2013. 9. 23.
 *      Author: parkmh
 */

#include "mc_traits.hh"
#include "mlmc_traits.hh"
#include "../../montecarlo/mlmc.hh"
#include "../../util/timer.hh"

int main(){
	typedef mlmc2d_tag mlmc_tag;
	typedef mlmc_traits<mlmc_tag,double> traits;
	typedef typename traits::coarsest_mc	coarsest_mc;
	typedef typename traits::mc_tag mc_tag;
	typedef typename mc_traits<mc_tag,double>::discretization discretization;
	typedef typename discretization::pos pos;
	typedef typename discretization::N N;


	N N_cst = 8;
	pos start, end, corrlen;
	start = 0.0;
	end =  1.0;

	double tol = 8e-1;

	MLMC<mlmc_tag,double> mlmc(start,end,N_cst,tol);
	mlmc.run();

	mlmc.set_tol(5e-1);
	mlmc.run();

	mlmc.set_tol(2e-1);
	mlmc.run();

	mlmc.set_tol(1e-1);
	mlmc.run();

	mlmc.set_tol(8e-2);
	mlmc.run();

	mlmc.set_tol(5e-2);
	mlmc.run();

	mlmc.set_tol(2e-2);
	mlmc.run();

	mlmc.set_tol(1e-2);
	mlmc.run();

	mlmc.set_tol(8e-3);
	mlmc.run();

	mlmc.set_tol(5e-3);
	mlmc.run();

	mlmc.set_tol(2e-3);
	mlmc.run();

	mlmc.set_tol(1e-3);
	mlmc.run();

	mlmc.set_tol(8e-4);
	mlmc.run();

	mlmc.set_tol(5e-4);
	mlmc.run();

	mlmc.set_tol(2e-4);
	mlmc.run();
}
