/*
 * fftfun.h
 *
 *  Created on: 2012. 6. 27.
 *      Author: parkmh
 */

#ifndef FFTFUN_H_
#define FFTFUN_H_

#include <fftw3.h>
#include <stdio.h>
#include "random.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LEX

int SqrtEvCirc1D(double *eigs, double *c,  size_t nx){
	size_t i;
	fftw_complex *out;
	fftw_plan plan_forward;

	size_t dx = 2*(nx);
	size_t dxh = (dx/2)+1;
	int nNegEVal = 0;
	out = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * dxh);
	plan_forward = fftw_plan_dft_r2c_1d ( dx, c, out, FFTW_ESTIMATE );
	fftw_execute ( plan_forward );

	for ( i = 0; i < dxh; i++ )
	{
		if ( out[i][0] < 0.0 ) {
			nNegEVal++;
		}
	}

	if (nNegEVal == 0){
		for ( i = 0; i < nx + 1; i++)
		{
			eigs[i] = sqrt(out[i][0]/dx);
		}
	}

	fftw_destroy_plan ( plan_forward );
	fftw_free ( out );
	fftw_cleanup();
	return nNegEVal;
}


int SqrtEvCirc2D(double *eigs, double *c,  size_t nx, size_t ny){
	size_t i, j;
	fftw_complex *out;
	fftw_plan plan_forward;

	size_t dx = 2*(nx);
	size_t dy = 2*(ny);
	size_t dxy = dx*dy;
	size_t dxh = (dx/2)+1;
//	size_t dyh = (dy/2)+1;


	int nNegEVal = 0;
//	out = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * dx * dyh);
//	plan_forward = fftw_plan_dft_r2c_2d ( dx, dy, c, out, FFTW_ESTIMATE );
	out = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * dy * dxh);
	plan_forward = fftw_plan_dft_r2c_2d ( dy, dx, c, out, FFTW_ESTIMATE );

	fftw_execute(plan_forward );

//	for (i = 0; i < dy*dxh; i++){
//		printf("out[%ld][0] = %f\n",i,out[i][0] );
//	}
//	printf("\n");
//	abort();
//	for (i = 0; i < dx*dy; i++){
//		printf("%.16f\n",c[i]);
//	}
//	printf("%ld\n",dx*dy);

	for ( i = 0; i < dxh * ((dy/2)+1); i++ )
	{
//		printf("checking %f\n",out[i][0]);
		if ( out[i][0] < 0.0 ) {
			nNegEVal++;
		}
	}

	if (nNegEVal == 0){

		for ( j = 0; j < ny + 1; j++)
		{
			for ( i = 0; i < nx + 1; i++)
			{
				eigs[i + (nx+1)*j] = sqrt(out[i + (nx+1)*j][0]/dxy);
//				printf("double-cheking %f\n",out[i + (nx+1)*j][0]);
			}
		}
	}

	fftw_destroy_plan ( plan_forward );
	fftw_free ( out );
	fftw_cleanup();

	return nNegEVal;
}

int SqrtEvCirc3D(double *eigs, double *c, size_t nx, size_t ny, size_t nz){
	size_t i, j, k;
	fftw_complex *out;
	fftw_plan plan_forward;

	size_t dx = 2*(nx);
	size_t dy = 2*(ny);
	size_t dz = 2*(nz);
	size_t nx1 = nx+1;
	size_t ny1 = ny+1;
	size_t nz1 = nz+1;
	size_t dxyz = dx*dy*dz;
	size_t dxh = (dx/2)+1;
	size_t dyh = (dy/2)+1;
	size_t dzh = (dz/2)+1;

	int nNegEVal = 0;

//	out = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * dx*dy * dzh);
//	plan_forward = fftw_plan_dft_r2c_3d ( dx, dy, dz, c, out, FFTW_ESTIMATE );
	out = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * dxh*dy *dz);
	plan_forward = fftw_plan_dft_r2c_3d ( dz, dy, dx, c, out, FFTW_ESTIMATE );
	fftw_execute ( plan_forward );

	for (i = 0; i < dz*dy*dxh; i++){
		printf("out[%ld][0] = %f\n",i,out[i][0] );
	}
	printf("\n");
//	abort();
	for (i = 0; i < dx*dy*dz; i++){
		printf("%.16f\n",c[i]);
	}
	printf("%ld, %ld, %ld\n",dx,dy,dz);


	for (k = 0; k < dzh; k++)
	{
		for (j = 0; j < dyh; j++)
		{
			for ( i = 0; i < dxh; i++ )
			{
//				if (out[k+dzh*(j+dy*i)][0] < 0.0 )
				printf("checking %f\n",out[i + dxh*(j+dy*k)][0]);
				if (out[i + dxh*(j+dy*k)][0] < 0.0 )
				{
					nNegEVal++;
				}
			}
		}
	}

	if (nNegEVal == 0){
		for ( k = 0; k < nz1; k++ ){
			for ( j = 0; j < ny1; j++){
				for ( i = 0; i < nx1; i++){
					printf("double-checking %f\n",out[i + dxh*(j+dy*k)][0]);
					eigs[i + nx1*(k*ny1+j)] = sqrt(out[i + dxh*(j+dx*k)][0]/dxyz);
				}
			}
		}

//		for ( i = 0; i < nx1; i++)
//				{
//					for ( j = 0; j < ny1; j++)
//					{
//						for ( k = 0; k < nz1; k++ )
//						{
//							eigs[k+nz1*(i*ny1+j)] = sqrt(out[k+dzh*(j+dy*i)][0]/dxyz);
//						}
//
//					}
//				}
	}
	fftw_destroy_plan ( plan_forward );
	fftw_free ( out );
	fftw_cleanup();
	return nNegEVal;
}

void ifft1d(double *x, double * z_real, double * z_imag, size_t nx){
	fftw_complex *in,*out;
	fftw_plan plan_backward;


	in  = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * nx);
	out = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * nx);
	for (size_t i = 0; i < nx; i++){
		in[i][0] = x[i];
		in[i][1] = 0.0;
	}

	plan_backward = fftw_plan_dft_1d( nx, in, out,  FFTW_BACKWARD, FFTW_ESTIMATE);
	fftw_execute ( plan_backward );
	for (size_t i = 0; i < nx; i++){
		z_real[i] = out[i][0]/(double)nx;
		z_imag[i] = out[i][1]/(double)nx;
	}


	fftw_destroy_plan(plan_backward);
	fftw_free(in);
	fftw_free(out);
	fftw_cleanup();
}

void ifft2d(double *x, double * z_real, double * z_imag, size_t nx, size_t ny){
	fftw_complex *in;
	fftw_complex *out;
	fftw_plan plan_backward;

	size_t nxy = nx*ny;
	in  = (fftw_complex*)fftw_malloc ( sizeof ( fftw_complex ) * nxy);
	out = (fftw_complex*)fftw_malloc ( sizeof ( fftw_complex ) * nxy);
	for (size_t i = 0; i < nxy; i++){
		in[i][0] = x[i];
		in[i][1] = 0.0;
	}

	plan_backward = fftw_plan_dft_2d( ny, nx, in, out,  FFTW_BACKWARD, FFTW_ESTIMATE);
	fftw_execute ( plan_backward );
//
	for (size_t i = 0; i < nxy; i++){
		z_real[i] = out[i][0]/(double)nxy;
		z_imag[i] = out[i][1]/(double)nxy;
	}
//
//
	fftw_destroy_plan(plan_backward);
	fftw_free(in);
	fftw_free(out);
	fftw_cleanup();
}

void ifft3d(double *x, double * z_real, double * z_imag, size_t nx, size_t ny, size_t nz){
	fftw_complex *in,*out;
	fftw_plan plan_backward;


	in  = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * nx*ny*nz);
	out = (fftw_complex*) fftw_malloc ( sizeof ( fftw_complex ) * nx*ny*nz);
	for (size_t i = 0; i < nx*ny*nz; i++){
		in[i][0] = x[i];
		in[i][1] = 0.0;
	}

	plan_backward = fftw_plan_dft_3d( nz,ny, nx, in, out,  FFTW_BACKWARD, FFTW_ESTIMATE);
	fftw_execute ( plan_backward );
	for (size_t i = 0; i < nx*ny*nz; i++){
		z_real[i] = out[i][0]/(double)(nx*ny*nz);
		z_imag[i] = out[i][1]/(double)(nx*ny*nz);
	}


	fftw_destroy_plan(plan_backward);
	fftw_free(in);
	fftw_free(out);
	fftw_cleanup();
}

void GetRealisation1D(const double *eigs, double *realsample, double *imagsample,
		size_t clenx, size_t nx)
{
	long idum_real, idum_imag;
	idum_real = -(long)rand();
	idum_imag = -(long)rand()-123456789;
	size_t dx = 2*(clenx-1);
	size_t index = 0;
	fftw_complex *in;
	fftw_complex *out;
	fftw_plan plan_forward;

	size_t i;

	in = (fftw_complex*)fftw_malloc ( sizeof ( fftw_complex ) * dx );
	for ( i = 0; i < clenx; i++)
	{
		in[index][0] = eigs[i]*randn(&idum_real);
		in[index][1] = eigs[i]*randn(&idum_imag);
		index++;

	}
	for ( i = clenx-2; i > 0; i--)
	{
		in[index][0] = eigs[i]*randn(&idum_real);
		in[index][1] = eigs[i]*randn(&idum_imag);
		index++;
	}
	out = (fftw_complex*)fftw_malloc ( sizeof ( fftw_complex ) * dx );

	plan_forward = fftw_plan_dft_1d ( dx, in, out, FFTW_FORWARD,FFTW_ESTIMATE );


	fftw_execute ( plan_forward );

	for ( i = 0; i < nx; i++)
	{
		realsample[i] = out[i][0];
		imagsample[i] = out[i][1];
	}

	fftw_destroy_plan ( plan_forward );

	fftw_free ( in );
	fftw_free ( out );
	fftw_cleanup();
}

void GetRealisation2D(const double *eigs,double *realsample, double *imagsample,
		size_t clenx, size_t cleny, size_t nx, size_t ny)
{
	long idum_real, idum_imag;
	idum_real = -(long)rand();
	idum_imag = -(long)rand()-123456789;
	size_t dx = 2*(clenx-1);
	size_t dy = 2*(cleny-1);
	size_t dxy = dx*dy;
	size_t index = 0;
	fftw_complex *in;
	fftw_complex *out;
	fftw_plan plan_forward;

	size_t i,j;

	in = (fftw_complex*)fftw_malloc ( sizeof ( fftw_complex ) * dxy );
	size_t jsize;
	for (j = 0; j < cleny; j++){
		jsize = j*clenx;
		for (i = 0; i < clenx; i++){
			in[index][0] = eigs[jsize+i]*randn(&idum_real);
			in[index][1] = eigs[jsize+i]*randn(&idum_imag);
			index++;
		}
		for (i = clenx-2; i > 0; i--){
			in[index][0] = eigs[jsize+i]*randn(&idum_real);
			in[index][1] = eigs[jsize+i]*randn(&idum_imag);
			index++;
		}
	}
	for (j = cleny-2; j > 0; j--){
		jsize = j*clenx;
		for (i = 0; i < clenx; i++){
			in[index][0] = eigs[jsize+i]*randn(&idum_real);
			in[index][1] = eigs[jsize+i]*randn(&idum_imag);
			index++;
		}
		for (i = clenx-2; i > 0; i--){
			in[index][0] = eigs[jsize+i]*randn(&idum_real);
			in[index][1] = eigs[jsize+i]*randn(&idum_imag);
			index++;
		}
	}


//	size_t isize;
//	for (i = 0; i < clenx; i++){
//		isize = i*cleny;
//		for (j = 0; j < cleny; j++){
//			in[index][0] = eigs[isize+j]*randn(&idum_real);
//			in[index][1] = eigs[isize+j]*randn(&idum_imag);
//			index++;
//		}
//		for (j = cleny-2; j > 0; j--){
//			in[index][0] = eigs[isize+j]*randn(&idum_real);
//			in[index][1] = eigs[isize+j]*randn(&idum_imag);
//			index++;
//		}
//	}
//	for (i = clenx-2; i > 0; i--){
//		isize = i *cleny;
//		for (j = 0; j < cleny; j++){
//			in[index][0] = eigs[isize+j]*randn(&idum_real);
//			in[index][1] = eigs[isize+j]*randn(&idum_imag);
//			index++;
//		}
//		for (j = cleny-2; j > 0; j--){
//			in[index][0] = eigs[isize+j]*randn(&idum_real);
//			in[index][1] = eigs[isize+j]*randn(&idum_imag);
//			index++;
//		}
//	}
	printf("dx = %ld, dy = %ld\n ",dx,dy);
	out = (fftw_complex*)fftw_malloc ( sizeof ( fftw_complex ) * dxy );
//	plan_forward = fftw_plan_dft_2d ( dx, dy, in, out, FFTW_FORWARD,FFTW_ESTIMATE );
	plan_forward = fftw_plan_dft_2d ( dy, dx, in, out, FFTW_FORWARD,FFTW_ESTIMATE );
	fftw_execute ( plan_forward );

#ifdef LEX
	for (j = 0; j < ny; j++)
	{
		for ( i = 0; i < nx; i++)
		{
			realsample[j*nx+i] = out[j*dx+i][0];
			imagsample[j*nx+i] = out[j*dx+i][1];
//			realsample[j*nx+i] = out[i*dy+j][0];
//						imagsample[j*nx+i] = out[i*dy+j][1];
		}
	}
#else
	for ( i = 0; i < nx; i++)
	{
		for (j = 0; j < ny; j++)
		{
			realsample[i*ny+j] = out[i*dy+j][0];
			imagsample[i*ny+j] = out[i*dy+j][1];
		}
	}
#endif
//	printf("%ldx%ld = %ld ...\n",nx,ny,nx*ny);
	fftw_destroy_plan ( plan_forward );

	fftw_free ( in );
	fftw_free ( out );
	fftw_cleanup();
}

void GetRealisation3D(const double *eigs,double *realsample, double *imagsample,
		size_t clenx, size_t cleny, size_t clenz,
		size_t nx, size_t ny, size_t nz)
{
	long idum_real, idum_imag;
	idum_real = -(long)rand();
	idum_imag = -(long)rand()-123456789;
	size_t dx = 2*(clenx-1);
	size_t dy = 2*(cleny-1);
	size_t dz = 2*(clenz-1);

	size_t dxyz = dx*dy*dz;

	size_t index = 0;
	fftw_complex *in;
	fftw_complex *out;
	fftw_plan plan_forward;

	size_t i,j,k;

	in = (fftw_complex*)fftw_malloc ( sizeof ( fftw_complex ) * dxyz );

	size_t kjsize;
	for ( k = 0; k < clenz; k++){
		for ( j = 0; j < cleny; j++){
			kjsize = clenx*(k*cleny+j);
			for ( i = 0; i < clenx; i++){
				in[index][0] = eigs[i + kjsize]*randn(&idum_real);
				in[index][1] = eigs[i + kjsize]*randn(&idum_imag);
				index++;
			}
			for ( i = clenx-2; i > 0; i--){
				in[index][0] = eigs[i + kjsize]*randn(&idum_real);
				in[index][1] = eigs[i + kjsize]*randn(&idum_imag);
				index++;
			}
		}
		for ( j = cleny-2; j > 0; j--){
			kjsize = clenx*(k*cleny+j);
			for ( i = 0; i < clenx; i++){
				in[index][0] = eigs[i + kjsize]*randn(&idum_real);
				in[index][1] = eigs[i + kjsize]*randn(&idum_imag);
				index++;
			}
			for ( i = clenx-2; i > 0; i--){
				in[index][0] = eigs[i + kjsize]*randn(&idum_real);
				in[index][1] = eigs[i + kjsize]*randn(&idum_imag);
				index++;
			}
		}
	}
	for ( k = clenz-2; k > 0; k--){
		for ( j = 0; j < cleny; j++){
			kjsize = clenx*(k*cleny+j);
			for ( i = 0; i < clenx; i++){
				in[index][0] = eigs[i + kjsize]*randn(&idum_real);
				in[index][1] = eigs[i + kjsize]*randn(&idum_imag);
				index++;
			}
			for ( i = clenx-2; i > 0; i--){
				in[index][0] = eigs[i + kjsize]*randn(&idum_real);
				in[index][1] = eigs[i + kjsize]*randn(&idum_imag);
				index++;
			}
		}
		for ( j = cleny-2; j > 0; j--){
			kjsize = clenx*(k*cleny+j);
			for ( i = 0; i < clenx; i++){
				in[index][0] = eigs[i + kjsize]*randn(&idum_real);
				in[index][1] = eigs[i + kjsize]*randn(&idum_imag);
				index++;
			}
			for ( i = clenx-2; i > 0; i--){
				in[index][0] = eigs[i + kjsize]*randn(&idum_real);
				in[index][1] = eigs[i + kjsize]*randn(&idum_imag);
				index++;
			}
		}
	}


//	size_t ijsize;
//	for ( i = 0; i < clenx; i++)
//	{
//		for ( j = 0; j < cleny; j++)
//		{
//			ijsize = clenz*(i*cleny+j);
//			for ( k = 0; k < clenz; k++)
//			{
//				in[index][0] = eigs[k + ijsize]*randn(&idum_real);
//				in[index][1] = eigs[k + ijsize]*randn(&idum_imag);
//				index++;
//			}
//			for ( k = clenz-2; k > 0; k--)
//			{
//				in[index][0] = eigs[k + ijsize]*randn(&idum_real);
//				in[index][1] = eigs[k + ijsize]*randn(&idum_imag);
//				index++;
//			}
//		}
//
//		for ( j = cleny-2; j > 0; j--)
//		{
//			ijsize = clenz*(i*cleny+j);
//			for ( k = 0; k < clenz; k++)
//			{
//				in[index][0] = eigs[k + ijsize]*randn(&idum_real);
//				in[index][1] = eigs[k + ijsize]*randn(&idum_imag);
//				index++;
//			}
//			for ( k = cleny-2; k > 0; k--)
//			{
//				in[index][0] = eigs[k + ijsize]*randn(&idum_real);
//				in[index][1] = eigs[k + ijsize]*randn(&idum_imag);
//				index++;
//			}
//		}
//	}
//	for ( i = clenx-2; i > 0; i--)
//	{
//		for ( j = 0; j < cleny; j++)
//		{
//			ijsize = clenz*(i*cleny+j);
//			for ( k = 0; k < clenz; k++)
//			{
//				in[index][0] = eigs[k + ijsize]*randn(&idum_real);
//				in[index][1] = eigs[k + ijsize]*randn(&idum_imag);
//				index++;
//			}
//			for ( k = clenz-2; k > 0; k--)
//			{
//				in[index][0] = eigs[k + ijsize]*randn(&idum_real);
//				in[index][1] = eigs[k + ijsize]*randn(&idum_imag);
//				index++;
//			}
//		}
//
//		for ( j = cleny-2; j > 0; j--)
//		{
//			ijsize = clenz*(i*cleny+j);
//			for ( k = 0; k < clenz; k++)
//			{
//				in[index][0] = eigs[k + ijsize]*randn(&idum_real);
//				in[index][1] = eigs[k + ijsize]*randn(&idum_imag);
//				index++;
//			}
//			for ( k = clenz-2; k > 0; k--)
//			{
//				in[index][0] = eigs[k + ijsize]*randn(&idum_real);
//				in[index][1] = eigs[k + ijsize]*randn(&idum_imag);
//				index++;
//			}
//		}
//	}

	out = (fftw_complex*)fftw_malloc ( sizeof ( fftw_complex ) * dxyz );
//	plan_forward = fftw_plan_dft_3d ( dx, dy, dz, in, out, FFTW_FORWARD,FFTW_ESTIMATE );
	plan_forward = fftw_plan_dft_3d ( dz, dy, dx, in, out, FFTW_FORWARD,FFTW_ESTIMATE );
	fftw_execute ( plan_forward );


#ifdef LEX
	for ( k = 0; k < nz; k++)
	{
		for (j = 0; j < ny; j++)
		{
			for ( i = 0; i < nx; i++)
			{
//				realsample[i + nx*(j + ny*k)] = out[k + dz*(i*dy+j)][0];
//				imagsample[i + nx*(j + ny*k)] = out[k + dz*(i*dy+j)][1];
				realsample[i + nx*(j + ny*k)] = out[i + dx*(k*dy+j)][0];
				imagsample[i + nx*(j + ny*k)] = out[i + dx*(k*dy+j)][1];
			}
		}
	}
#else
	for ( i = 0; i < nx; i++)
	{
		for (j = 0; j < ny; j++)
		{
			for ( k = 0; k < nz; k++)
			{
				realsample[k + nz*(i*ny+j)] = out[k + dz*(i*dy+j)][0];
				imagsample[k + nz*(i*ny+j)] = out[k + dz*(i*dy+j)][1];
			}
		}
	}
#endif
	fftw_destroy_plan ( plan_forward );

	fftw_free ( in );
	fftw_free ( out );
	fftw_cleanup();
}

#ifdef __cplusplus
}
#endif
#endif /* FFTFUN_H_ */
