# PCO with mixed variables

source("funcs.R")
require(ade4)

data(dunedata)

attributes(dunedata$envir$use)$class <- "factor"   # use dudi.mix for ordered data
dd1 <- dudi.hillsmith(dunedata$envir, scann = FALSE)

# mapping from data space to score space L=XQA
as.matrix(dd1$tab) %*% diag(dd1$cw) %*% as.matrix(dd1$c1)
# verify that this produces the same as (row scores)
dd1$li

# mapping from score space to data space X

examscore <- c(1,0)
mapx <- as.numeric(as.matrix(dd1$c1) %*% examscore)


# maps from dummied X to real X
dxtox(mapx)

# computing representation along PC1

pdf("dunepco.pdf",height=4,width=6)
par(mfrow=c(2,5),mgp=c(1.5,0.5,0),mar=c(2.6,2.1,2.1,0.1),tck=-0.01)

pc1 <- cbind(seq(-2,2,len=100),0)
mapx <- as.matrix(dd1$c1) %*% t(pc1)
mm <- dxtox(mapx)

plot(mm[,1] ~ pc1[,1], ylim=c(-2,2),ylab="",xlab="PC1",type="l",main="A1")
plot(mm[,2] ~ pc1[,1], ylim=c(-2,2),ylab="",xlab="PC1",type="l",main="Moisture")
plot(mm[,3] ~ pc1[,1], ylim=c(-2,2),ylab="",xlab="PC1",type="l",main="Manure")

ll <- levels(dunedata$envir$use)
nl <- length(ll)
y <- match(mm[,4],ll)
plot(y ~ pc1[,1],ylim=c(1,nl),ylab="",xlab="PC1",pch=15,main="Use",axes=FALSE, frame.plot=TRUE)
axis(1)
axis(2,at=1:nl,labels=ll)

ll <- levels(dunedata$envir$manag)
nl <- length(ll)
y <- match(mm[,5],ll)
plot(y ~ pc1[,1],ylim=c(1,nl),ylab="",xlab="PC1",pch=15,main="Manag",axes=FALSE, frame.plot=TRUE)
axis(1)
axis(2,at=1:nl,labels=ll)

# computing representation along PC2
pc2 <- cbind(0,seq(-2,2,len=100))
mapx <- as.matrix(dd1$c1) %*% t(pc2)
mm <- dxtox(mapx)

plot(mm[,1] ~ pc2[,2], ylim=c(-2,2),ylab="",xlab="PC2",type="l",main="A1")
plot(mm[,2] ~ pc2[,2], ylim=c(-2,2),ylab="",xlab="PC2",type="l",main="Moisture")
plot(mm[,3] ~ pc2[,2], ylim=c(-2,2),ylab="",xlab="PC2",type="l",main="Manure")

ll <- levels(dunedata$envir$use)
nl <- length(ll)
y <- match(mm[,4],ll)
plot(y ~ pc2[,2],ylim=c(1,nl),ylab="",xlab="PC2",pch=15,main="Use",axes=FALSE, frame.plot=TRUE)
axis(1)
axis(2,at=1:nl,labels=ll)

ll <- levels(dunedata$envir$manag)
nl <- length(ll)
y <- match(mm[,5],ll)
plot(y ~ pc2[,2],ylim=c(1,nl),ylab="",xlab="PC2",pch=15,main="Manag",axes=FALSE, frame.plot=TRUE)
axis(1)
axis(2,at=1:nl,labels=ll)

dev.off()

# data simulation


nrep <- 100
simd <- matrix(NA,nrep,13)

for(i in 1:100){
  scorex <- matrix(rnorm(40),2,20)
  scorex <- scorex * sqrt(dd1$eig[1:2])
  x <- as.matrix(dd1$c1) %*% scorex
  gx <- gendata(x)

  levels(gx$manag) <- levels(dunedata$envir$manag)
  levels(gx$use) <- c("both","grazing","hayfield")
  
  simd[i,1:3] <- colMeans(gx[,1:3])
  simd[i,4:6] <- sd(gx[,1:3])
  simd[i,7:9] <- table(gx[,4])
  simd[i,10:13] <- table(gx[,5])
}
