%% Plot regime diagrams, in two sets of coordinates.
%% First, E (x-axis) against r0 (y-axis).
%% Then, b (x-axis) against k (y-axis).

%% Geometrically, we need to incorporate an assumption about the relationship between r0 and k.
%% Set k= \ell /(2 r0) where \ell is a measure of the total length of lineages
%% that should be covered by clusters.

%% Copyright Vo, Dawes & Kelsh, 2023 - 2024.

%% Generates Figure 13 in Vo, Dawes & Kelsh paper.

close all; clear all;


a=0.1;
c=10;
ell=10;  % typical value, used in Figure 13.

E_arr=1:0.001:4;                     % array of values of E
r0_arr=(3-E_arr)./(3*c*(E_arr-1));
r0_arr=r0_arr.*(r0_arr>0);           % replace negative values by zeros.


b_arr=(2*pi*a)./(3*log(E_arr));
k_arr=ell./(2*r0_arr);
b_asymp=(2*pi*a)./(3*log(3));       % location of asymptote.
kmax=50;                            % plot region parameter.
bmax=5.0;                           % max(b_arr);

figure(1);
plot(E_arr,r0_arr,'-b','LineWidth',2);
hold on;
ax=gca;
set(gca,'FontSize',12);
xlabel('$$ E $$','Interpreter','latex','FontSize',16);
ylabel('$$ r_0 $$','Interpreter','latex','FontSize',16);
axis([1 4 -0.05 4e-01]);
plot([1 4],[0 0],'-k','LineWidth',0.5);


figure(2);
semilogx(b_arr,k_arr,'-b','LineWidth',2);
hold on;
ax=gca;
set(gca,'FontSize',12);
xlabel('$$ b $$','Interpreter','latex','FontSize',16);
ylabel('$$ k $$','Interpreter','latex','FontSize',16);
axis([1e-01 bmax 0 kmax]);
plot([b_asymp b_asymp],[0 kmax],'--k','LineWidth',1); % add asymptote to the plot.

