


/*************************************************************************/
/*                                                                       */
/*                       Program k2d.c (version 1.2)                     */
/*                                                                       */
/*                          date 16/6/1993                               */
/*************************************************************************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define SIZINPUT  41
#define SIZOUTPUT 13
#define entrenas 100
#define MDia entrenas

unsigned int    k,i, j, ichi, corte,
		l, prime,prime2,max1,
		max2, protrep = 100;

int high_error;

char salidapor[13],salidacd[13],entrada[13];

float           pp,derror,dum,dmax,
		WeightsMu[SIZOUTPUT][SIZOUTPUT][SIZINPUT],
		Porcent[SIZOUTPUT][SIZOUTPUT][3],
		dist[SIZOUTPUT][SIZOUTPUT],
		poblema[SIZINPUT],
		CD[entrenas][SIZINPUT],
		Dis[entrenas],disal,cdsal[SIZINPUT],porsal[3],
		POR[entrenas][3],aux,aux1,aux2;

FILE           *fichero,*fichero2,*fichero3,*fileSamples;

/***********************************************************************************************/

void main()
{

    void Loadsamples();
    void Load();


	     /* Getting the weights values */

    if ((fichero3 = fopen("weights.dat", "r")) == NULL) {
	printf("I cannot find the weights file \n");
	exit(1);
	}

    pp=1.0*MDia;
    Loadsamples();

    printf("\n ******************************************************* \n");
    printf("\n The output percent file has the secondary structure ");
    printf("\n prediction values and the error evaluation.          ");
    printf("\n ******************************************************* \n");

    printf("\nName of the output percent file : ");
    scanf(" %s",salidapor);

    if ((fichero = fopen (salidapor, "w")) == NULL) {
     printf("ERROR opening the percent file \n");
     exit(1);
    }

    printf("\n ******************************************************* \n");
    printf("\n The output CD file has three columns that are ");
    printf("\n lambda values : CD sample values : CD calculated values ");
    printf("\n ******************************************************* \n");

    printf("\nName of the output CD spectrum file : ");
    scanf(" %s",salidacd);

    if ((fichero2 = fopen(salidacd, "w")) == NULL) {
     printf("ERROR opening the output CD file  \n");
     exit(1);
    }

    for (i = 0; i< entrenas; i++) {

     dmax=1e8;

     Load();


     for (prime = 0; prime < SIZOUTPUT; prime++)
	for (prime2 = 0; prime2 < SIZOUTPUT; prime2++) {
	  dist[prime][prime2]=0;

	     /* computation of the distance from the sample to
		each neuron  */

	  for (ichi = 0; ichi < SIZINPUT-corte; ichi++) {
	   dum=WeightsMu[prime][prime2][ichi]-poblema[ichi];
	   dist[prime][prime2]+=dum*dum;
	  }

	   /* searching the winning neuron */

	  if (dmax > dist[prime][prime2]) {
	    max1=prime;
	    max2=prime2;
	    dmax=dist[prime][prime2];
	  }

       }

      /* getting the CD and the percentage values of the winning neuron */

      for (ichi = 0; ichi < SIZINPUT-corte; ichi++)
	CD[i][ichi]=WeightsMu[max1][max2][ichi];

      Dis[i]=dmax;

      POR[i][0]=Porcent[max1][max2][0];
      POR[i][1]=Porcent[max1][max2][1];
      POR[i][2]=Porcent[max1][max2][2];

     }

   /* Averaging the winning neuron spectra and percentages */

   disal=0;

    for (i = 0; i< entrenas; i++) {
     k = 0;
      for (j = 0; j < entrenas; j++)
	 if (Dis[j] < Dis[i]) k++;
	 if (k < MDia ) {
		 for (ichi = 0; ichi < SIZINPUT-corte; ichi++)
		 cdsal[ichi]+=CD[i][ichi];
		 disal+=Dis[i];
		 for (l = 0; l< 3; l++)
		 porsal[l]+= POR[i][l];
	  }
     }


    fprintf(fichero,"\n\n\n ALPHA -> %2.2f",porsal[0]/pp);
    fprintf(fichero,"\n BETA -> %2.2f",porsal[1]/pp);
    fprintf(fichero,"\n RANDOM -> %2.2f",porsal[2]/pp);
    fprintf(fichero,"\n\n\n SQUARE DISTANCE: %2.2f",disal/pp);

    /* error calculation */

    high_error = 0;
    disal =(disal/pp);
    if (disal<5)
     derror = 0.050;
      else if (disal<36)
       derror = 0.080;
	else if (disal<39)
	 derror = 0.085;
	  else if (disal<44)
	   derror = 0.087;
	    else if (disal<50)
	     derror = 0.097;
	      else if (disal<67)
	       derror = 0.122;
		else if (disal<99)
		 derror = 0.182;
		  else if (disal<105)
		   derror = 0.227;
		    else high_error = 1;

    if (high_error == 0)
      fprintf(fichero,"\n MAX ERROR: %3.3f",derror);
       else fprintf(fichero,"\n Distance too large. MAX ERROR > 0.227");


    i=199;
    for (ichi =SIZINPUT-corte-1 ; ichi<-1 ; ichi--)
     fprintf(fichero2," %d %2.2f %2.2f \n",i+=1,-poblema[ichi],-cdsal[ichi]/pp);

    fclose(fichero);
    fclose(fichero2);
    fclose(fichero3);
 }


/************************************************************************************/
void
Load() {

   unsigned int    ichi;
   float           aux,aux1,aux2;

	for (prime = 0; prime < SIZOUTPUT; prime++)
		for (prime2 = 0; prime2 < SIZOUTPUT; prime2++) {

				for (ichi = 0; ichi < SIZINPUT; ichi++) {
				 fscanf(fichero3, "%f ", &aux);
					WeightsMu[prime][prime2][ichi]=aux;

				 }

		     fscanf(fichero3, "%f %f %f", &aux,&aux1,&aux2);
		     Porcent[prime][prime2][0]=aux;
		     Porcent[prime][prime2][1]=aux1;
		     Porcent[prime][prime2][2]=aux2;
	   }

}

/************************************************************************************/
void
Loadsamples()
{
	unsigned int    ichi;
	float           aux, inte[SIZINPUT];
	FILE            *filesamples;

	printf("\n ******************************************************* \n");
	printf(" \n The input CD spectra file must contain 41 CD values");
	printf(" \n ranging from 200 nm to 240 nm ");
	printf("\n ******************************************************* \n");

	printf("\nName of the input CD spectra file : ");
	scanf(" %s",entrada);

	if ((fileSamples = fopen(entrada, "r")) == NULL) {
		printf("ERROR opennig the input CD file\n");
		exit(1);
	}
	corte=0;
	 while (!feof(fileSamples)) {
	    fscanf(fileSamples, "%f", &aux);
	    inte[corte]=-aux;
	    corte++;
	   }
       corte=SIZINPUT-corte+1;
	for (ichi = 0; ichi <SIZINPUT-corte; ichi++)
	   poblema[SIZINPUT-corte-ichi-1]=inte[ichi];
       fclose(fileSamples);
 }
